/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.openaire.community.model.DbCommunity;
import eu.dnetlib.openaire.community.model.DbCommunityType;
import eu.dnetlib.openaire.community.model.DbDatasource;
import eu.dnetlib.openaire.community.model.DbOrganization;
import eu.dnetlib.openaire.community.model.DbProject;
import eu.dnetlib.openaire.community.model.DbSupportOrg;
import eu.dnetlib.openaire.exporter.model.community.CommunityDatasource;
import eu.dnetlib.openaire.exporter.model.community.CommunityDatasourceExtended;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetailsExtended;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityPlanType;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunityProjectExtended;
import eu.dnetlib.openaire.exporter.model.community.CommunityPropagationOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityType;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.SubCommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.context.IISConfigurationEntry;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommunityMappingUtils {
    public static final String COMMUNITY_ID_PARTS_SEPARATOR = "::";
    public static final String PIPE_SEPARATOR = "||";
    private static final List<String> DATE_PATTERN = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm:ssXXX", "yyyy-MM-dd'T'hh:mm:ss+00:00"});
    private static final Log log = LogFactory.getLog(CommunityMappingUtils.class);

    public static CommunitySummary toCommunitySummary(DbCommunity c) {
        CommunitySummary summary = new CommunitySummary();
        CommunityMappingUtils.populateSummary((CommunitySummary)summary, (DbCommunity)c);
        return summary;
    }

    public static DbCommunity toCommunity(CommunityDetails details) {
        DbCommunity c = new DbCommunity();
        c.setId(details.getId());
        c.setName(details.getName());
        c.setShortName(details.getShortName());
        c.setDisplayName(details.getDisplayName());
        c.setDisplayShortName(details.getDisplayShortName());
        c.setDescription(details.getDescription());
        c.setStatus(details.getStatus());
        c.setLogoUrl(details.getLogoUrl());
        c.setMembership(details.getMembership());
        c.setType(CommunityMappingUtils.toDbCommunityType((CommunityType)details.getType()));
        c.setClaim(details.getClaim());
        c.setSubjects(CommunityMappingUtils.toStringArray((List)details.getSubjects()));
        c.setFos(CommunityMappingUtils.toStringArray((List)details.getFos()));
        c.setSdg(CommunityMappingUtils.toStringArray((List)details.getSdg()));
        c.setAdvancedConstraints(details.getAdvancedConstraints());
        c.setRemoveConstraints(details.getRemoveConstraints());
        c.setMainZenodoCommunity(details.getZenodoCommunity());
        c.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)details.getOtherZenodoCommunities()));
        c.setSuggestedAcknowledgements(CommunityMappingUtils.toStringArray((List)details.getSuggestedAcknowledgements()));
        c.setPlan(details.getPlan());
        c.setCreationDate((LocalDateTime)ObjectUtils.firstNonNull((Object[])new LocalDateTime[]{details.getCreationDate(), LocalDateTime.now()}));
        c.setLastUpdateDate(LocalDateTime.now());
        c.setFeatured(details.getFeatured());
        return c;
    }

    public static void populateCommunity(DbCommunity c, CommunityWritableProperties details) {
        if (StringUtils.isNotBlank((CharSequence)details.getName())) {
            c.setName(details.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getShortName())) {
            c.setShortName(details.getShortName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getDisplayName())) {
            c.setDisplayName(details.getDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getDisplayShortName())) {
            c.setDisplayShortName(details.getDisplayShortName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getDescription())) {
            c.setDescription(details.getDescription());
        }
        if (details.getStatus() != null) {
            c.setStatus(details.getStatus());
        }
        if (details.getMembership() != null) {
            c.setMembership(details.getMembership());
        }
        if (details.getType() != null) {
            c.setType(CommunityMappingUtils.toDbCommunityType((CommunityType)details.getType()));
        }
        if (details.getClaim() != null) {
            c.setClaim(details.getClaim());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getLogoUrl())) {
            c.setLogoUrl(details.getLogoUrl());
        }
        if (details.getFos() != null) {
            c.setFos(CommunityMappingUtils.toStringArray((List)details.getFos()));
        }
        if (details.getSdg() != null) {
            c.setSdg(CommunityMappingUtils.toStringArray((List)details.getSdg()));
        }
        if (details.getSubjects() != null) {
            c.setSubjects(CommunityMappingUtils.toStringArray((List)details.getSubjects()));
        }
        if (details.getAdvancedConstraints() != null) {
            c.setAdvancedConstraints(details.getAdvancedConstraints());
        }
        if (details.getRemoveConstraints() != null) {
            c.setRemoveConstraints(details.getRemoveConstraints());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getMainZenodoCommunity())) {
            c.setMainZenodoCommunity(details.getMainZenodoCommunity());
        }
        if (details.getOtherZenodoCommunities() != null) {
            c.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)details.getOtherZenodoCommunities()));
        }
        if (details.getPlan() != null) {
            c.setPlan(details.getPlan());
        }
        if (details.getFeatured() != null) {
            c.setFeatured(details.getFeatured());
        }
        c.setLastUpdateDate(LocalDateTime.now());
    }

    public static void populateCommunity(DbCommunity c, SubCommunityWritableProperties details) {
        if (StringUtils.isNotBlank((CharSequence)details.getLabel())) {
            c.setName(details.getLabel());
            c.setShortName(details.getLabel());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getCategory())) {
            c.setCategory(details.getCategory());
        }
        if (details.getParams() != null) {
            c.setParams(details.getParams());
        }
        if (details.getClaim() != null) {
            c.setClaimable(details.getClaim());
        }
        if (details.getBrowsable() != null) {
            c.setBrowsable(details.getBrowsable());
        }
        if (details.getFos() != null) {
            c.setFos(CommunityMappingUtils.toStringArray((List)details.getFos()));
        }
        if (details.getSdg() != null) {
            c.setSdg(CommunityMappingUtils.toStringArray((List)details.getSdg()));
        }
        if (details.getSubjects() != null) {
            c.setSubjects(CommunityMappingUtils.toStringArray((List)details.getSubjects()));
        }
        if (details.getAdvancedConstraints() != null) {
            c.setAdvancedConstraints(details.getAdvancedConstraints());
        }
        if (details.getRemoveConstraints() != null) {
            c.setRemoveConstraints(details.getRemoveConstraints());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getZenodoCommunity())) {
            c.setMainZenodoCommunity(details.getZenodoCommunity());
        }
        if (details.getOtherZenodoCommunities() != null) {
            c.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)details.getOtherZenodoCommunities()));
        }
        if (details.getSuggestedAcknowledgements() != null) {
            c.setSuggestedAcknowledgements(CommunityMappingUtils.toStringArray((List)details.getSuggestedAcknowledgements()));
        }
        c.setLastUpdateDate(LocalDateTime.now());
    }

    public static CommunityDetailsExtended toCommunityDetails(DbCommunity c) {
        CommunityDetailsExtended details = new CommunityDetailsExtended();
        CommunityMappingUtils.populateSummary((CommunitySummary)details, (DbCommunity)c);
        details.setAdvancedConstraints(c.getAdvancedConstraints());
        details.setRemoveConstraints(c.getRemoveConstraints());
        details.setFos(Arrays.asList(c.getFos()));
        details.setSdg(Arrays.asList(c.getSdg()));
        details.setSubjects(Arrays.asList(c.getSubjects()));
        details.setOtherZenodoCommunities(Arrays.asList(c.getOtherZenodoCommunities()));
        details.setSuggestedAcknowledgements(Arrays.asList(c.getSuggestedAcknowledgements()));
        return details;
    }

    private static void populateSummary(CommunitySummary summary, DbCommunity c) {
        summary.setId(c.getId());
        summary.setName(c.getName());
        summary.setShortName(c.getShortName());
        summary.setDisplayName(c.getDisplayName());
        summary.setDisplayShortName(c.getDisplayShortName());
        summary.setLastUpdateDate(c.getLastUpdateDate());
        summary.setCreationDate(c.getCreationDate());
        summary.setQueryId(c.getId() + "||" + c.getShortName());
        summary.setType(CommunityMappingUtils.toCommunityType((DbCommunityType)c.getType()));
        summary.setDescription(c.getDescription());
        summary.setLogoUrl(c.getLogoUrl());
        summary.setStatus(c.getStatus());
        summary.setClaim(c.getClaim());
        summary.setMembership(c.getMembership());
        summary.setZenodoCommunity(c.getMainZenodoCommunity());
        summary.setPlan(c.getPlan());
        summary.setFeatured(c.getFeatured());
    }

    private static DbCommunityType toDbCommunityType(CommunityType type) {
        if (type == CommunityType.community) {
            return DbCommunityType.community;
        }
        if (type == CommunityType.ri) {
            return DbCommunityType.ri;
        }
        return null;
    }

    private static CommunityType toCommunityType(DbCommunityType type) {
        if (type == DbCommunityType.community) {
            return CommunityType.community;
        }
        if (type == DbCommunityType.ri) {
            return CommunityType.ri;
        }
        if (type == DbCommunityType.subcommunity) {
            throw new RuntimeException("Invalid type (subcommunity)");
        }
        return null;
    }

    public static CommunityProjectExtended toCommunityProject(DbProject dbEntry, String communityName) {
        CommunityProjectExtended cp = new CommunityProjectExtended();
        cp.setCommunityId(dbEntry.getCommunity());
        cp.setCommunityName(communityName);
        cp.setOpenaireId(dbEntry.getProjectId());
        cp.setName(dbEntry.getProjectName());
        cp.setAcronym(dbEntry.getProjectAcronym());
        cp.setFunder(dbEntry.getProjectFunder());
        cp.setGrantId(dbEntry.getProjectCode());
        cp.setAvailableSince(dbEntry.getAvailableSince());
        return cp;
    }

    public static DbProject toDbProject(String id, CommunityProject project) {
        DbProject p = new DbProject();
        p.setCommunity(id);
        p.setProjectId(project.getOpenaireId());
        p.setProjectName(project.getName());
        p.setProjectAcronym(project.getAcronym());
        p.setProjectCode(project.getGrantId());
        p.setProjectFunder(project.getFunder());
        if (project.getAvailableSince() != null) {
            p.setAvailableSince(project.getAvailableSince());
        } else {
            p.setAvailableSince(LocalDate.now());
        }
        return p;
    }

    public static CommunityDatasourceExtended toCommunityContentprovider(DbDatasource dbEntry, String communityName) {
        CommunityDatasourceExtended ccp = new CommunityDatasourceExtended();
        ccp.setCommunityId(dbEntry.getCommunity());
        ccp.setCommunityName(communityName);
        ccp.setOpenaireId(dbEntry.getDsId());
        ccp.setName(dbEntry.getDsName());
        ccp.setOfficialname(dbEntry.getDsOfficialName());
        ccp.setSelectioncriteria(dbEntry.getConstraints());
        ccp.setEnabled(dbEntry.getEnabled() != null ? dbEntry.getEnabled() : true);
        ccp.setDeposit(Boolean.valueOf(dbEntry.getDeposit() != null ? dbEntry.getDeposit() : false));
        ccp.setMessage(dbEntry.getMessage());
        return ccp;
    }

    public static DbDatasource toDbDatasource(String id, CommunityDatasource provider) {
        DbDatasource ds = new DbDatasource();
        ds.setCommunity(id);
        ds.setDsId(provider.getOpenaireId());
        ds.setDsName(provider.getName());
        ds.setDsOfficialName(provider.getOfficialname());
        ds.setConstraints(provider.getSelectioncriteria());
        ds.setEnabled(Boolean.valueOf(provider.isEnabled()));
        ds.setDeposit(Boolean.valueOf(provider.getDeposit() != null ? provider.getDeposit() : false));
        ds.setMessage(provider.getMessage());
        return ds;
    }

    public static CommunityOrganization toCommunityOrganization(DbSupportOrg dbEntry) {
        CommunityOrganization co = new CommunityOrganization();
        co.setCommunityId(dbEntry.getCommunity());
        co.setName(dbEntry.getOrgName());
        co.setWebsite_url(dbEntry.getOrgUrl());
        co.setLogo_url(dbEntry.getOrgLogoUrl());
        return co;
    }

    public static DbSupportOrg toDbSupportOrg(String id, CommunityOrganization org) {
        DbSupportOrg dbo = new DbSupportOrg();
        dbo.setCommunity(id);
        dbo.setOrgName(org.getName());
        dbo.setOrgUrl(org.getWebsite_url());
        dbo.setOrgLogoUrl(org.getLogo_url());
        return dbo;
    }

    public static DbCommunity toDbCommunity(SubCommunity sub) {
        DbCommunity dbsc = new DbCommunity();
        dbsc.setId(sub.getSubCommunityId());
        dbsc.setParent(sub.getParent());
        dbsc.setType(DbCommunityType.subcommunity);
        dbsc.setCategory(sub.getCategory());
        dbsc.setName(sub.getLabel());
        dbsc.setShortName(sub.getLabel());
        dbsc.setDescription("");
        dbsc.setPlan(CommunityPlanType.Default);
        dbsc.setParams(sub.getParams());
        dbsc.setClaimable(Boolean.valueOf(sub.isClaim()));
        dbsc.setBrowsable(Boolean.valueOf(sub.isBrowsable()));
        dbsc.setAdvancedConstraints(sub.getAdvancedConstraints());
        dbsc.setRemoveConstraints(sub.getRemoveConstraints());
        dbsc.setFos(CommunityMappingUtils.toStringArray((List)sub.getFos()));
        dbsc.setSdg(CommunityMappingUtils.toStringArray((List)sub.getSdg()));
        dbsc.setSubjects(CommunityMappingUtils.toStringArray((List)sub.getSubjects()));
        dbsc.setMainZenodoCommunity(sub.getZenodoCommunity());
        dbsc.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)sub.getOtherZenodoCommunities()));
        dbsc.setSuggestedAcknowledgements(CommunityMappingUtils.toStringArray((List)sub.getSuggestedAcknowledgements()));
        dbsc.setCreationDate(LocalDateTime.now());
        dbsc.setLastUpdateDate(LocalDateTime.now());
        dbsc.setFeatured(null);
        return dbsc;
    }

    public static SubCommunity toSubCommunity(DbCommunity sub) {
        SubCommunity sc = new SubCommunity();
        sc.setSubCommunityId(sub.getId());
        sc.setCommunityId(CommunityMappingUtils.calculateMainCommunityId((String)sub.getId()));
        sc.setParent(sub.getParent());
        sc.setCategory(sub.getCategory());
        sc.setLabel(sub.getName());
        sc.setParams(sub.getParams());
        sc.setClaim(((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{sub.getClaimable(), false})).booleanValue());
        sc.setBrowsable(((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{sub.getBrowsable(), false})).booleanValue());
        sc.setAdvancedConstraints(sub.getAdvancedConstraints());
        sc.setRemoveConstraints(sub.getRemoveConstraints());
        sc.setFos(Arrays.asList(sub.getFos()));
        sc.setSdg(Arrays.asList(sub.getSdg()));
        sc.setSubjects(Arrays.asList(sub.getSubjects()));
        sc.setZenodoCommunity(sub.getMainZenodoCommunity());
        sc.setOtherZenodoCommunities(Arrays.asList(sub.getOtherZenodoCommunities()));
        sc.setSuggestedAcknowledgements(Arrays.asList(sub.getSuggestedAcknowledgements()));
        return sc;
    }

    public static CommunityPropagationOrganization toCommunityPropagationOrganization(DbOrganization dbEntry) {
        CommunityPropagationOrganization co = new CommunityPropagationOrganization();
        co.setOrgId(dbEntry.getOrgId());
        co.setDescription((String)StringUtils.firstNonBlank((CharSequence[])new String[]{dbEntry.getDescription(), ""}));
        co.setSubscribed(dbEntry.getIsSubscribed() != null && dbEntry.getIsSubscribed() != false);
        return co;
    }

    public static String calculateMainCommunityId(String sub) {
        return StringUtils.substringBefore((String)sub, (String)"::");
    }

    public static LocalDateTime asLocalDateTime(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        for (String pattern : DATE_PATTERN) {
            try {
                Date res = DateUtils.parseDate((String)s, (String[])new String[]{pattern});
                if (res == null) continue;
                return CommunityMappingUtils.asLocalDateTime((Date)res);
            }
            catch (ParseException parseException) {
            }
        }
        log.warn((Object)("Invalid Date: " + s));
        return null;
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static String[] toStringArray(List<String> list) {
        return list != null ? list.toArray(new String[list.size()]) : new String[]{};
    }

    public static IISConfigurationEntry asIISConfigurationEntry(DbCommunity c) {
        IISConfigurationEntry conf = new IISConfigurationEntry();
        conf.setId(c.getId());
        conf.setLabel(c.getName());
        if (c.getParent() == null) {
            conf.addParams("description", new String[]{c.getDescription()});
            conf.addParams("logourl", new String[]{c.getLogoUrl()});
            conf.addParams("status", new String[]{c.getStatus().toString()});
            conf.addParams("name", new String[]{c.getName()});
            conf.addParams("zenodoCommunity", new String[]{c.getMainZenodoCommunity()});
            conf.addParams("subject", c.getSubjects());
            conf.addParams("fos", c.getFos());
            conf.addParams("sdg", c.getSdg());
            conf.addParams("advancedConstraints", new String[]{c.getAdvancedConstraints() != null ? c.getAdvancedConstraints().toJson() : null});
            conf.addParams("removeConstraints", new String[]{c.getRemoveConstraints() != null ? c.getRemoveConstraints().toJson() : null});
            conf.addParams("suggestedAcknowledgement", c.getSuggestedAcknowledgements());
            conf.addParams("creationdate", new String[]{c.getCreationDate() != null ? c.getCreationDate().toString() : null});
        } else if (c.getParams() != null) {
            conf.getParams().addAll(c.getParams());
        }
        return conf;
    }

    public static boolean isValidCommunityId(String id) {
        return StringUtils.isNotBlank((CharSequence)id) && !StringUtils.contains((CharSequence)id, (CharSequence)"::");
    }

    public static boolean isValidSubCommunityId(String subcommunityId) {
        return StringUtils.isNotBlank((CharSequence)subcommunityId) && StringUtils.split((String)subcommunityId, (String)"::").length > 1;
    }
}

