/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.SuggestionInfo;
import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.model.OpenaireDuplicate;
import eu.dnetlib.organizations.model.utils.BrowseEntry;
import eu.dnetlib.organizations.model.utils.OrganizationConflict;
import eu.dnetlib.organizations.model.view.ConflictGroupView;
import eu.dnetlib.organizations.model.view.DuplicateGroupView;
import eu.dnetlib.organizations.model.view.OpenaireDuplicateView;
import eu.dnetlib.organizations.model.view.OrganizationInfoView;
import eu.dnetlib.organizations.model.view.OrganizationSimpleView;
import eu.dnetlib.organizations.model.view.OrganizationView;
import eu.dnetlib.organizations.repository.UserCountryRepository;
import eu.dnetlib.organizations.repository.readonly.ConflictGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.DuplicateGroupViewRepository;
import eu.dnetlib.organizations.repository.readonly.OpenaireDuplicateViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationInfoViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationSimpleViewRepository;
import eu.dnetlib.organizations.repository.readonly.OrganizationViewRepository;
import eu.dnetlib.organizations.repository.readonly.SuggestionInfoViewByCountryRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.OrganizationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/organizations"})
public class OrganizationController {
    @Autowired
    private OrganizationViewRepository organizationViewRepository;
    @Autowired
    private OrganizationInfoViewRepository organizationInfoViewRepository;
    @Autowired
    private OrganizationSimpleViewRepository organizationSimpleViewRepository;
    @Autowired
    private OpenaireDuplicateViewRepository openaireDuplicateViewRepository;
    @Autowired
    private ConflictGroupViewRepository conflictGroupViewRepository;
    @Autowired
    private SuggestionInfoViewByCountryRepository suggestionInfoViewByCountryRepository;
    @Autowired
    private UserCountryRepository userCountryRepository;
    @Autowired
    private DuplicateGroupViewRepository duplicateGroupViewRepository;
    @Autowired
    private DatabaseUtils databaseUtils;

    @PostMapping(value={"/save"})
    public List<String> save(@RequestBody OrganizationView org, Authentication authentication) {
        if (StringUtils.isBlank((CharSequence)org.getName())) {
            throw new RuntimeException("Missing field: name");
        }
        if (StringUtils.isBlank((CharSequence)org.getCountry())) {
            throw new RuntimeException("Missing field: country");
        }
        if (StringUtils.isBlank((CharSequence)org.getType())) {
            throw new RuntimeException("Missing field: type");
        }
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), authentication.getName())) {
            String orgId = this.databaseUtils.insertOrUpdateOrganization(org, authentication.getName(), UserInfo.isSimpleUser((Authentication)authentication));
            return Arrays.asList(orgId);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/info"})
    public OrganizationInfoView infoById(@RequestParam String id, Authentication authentication) {
        return (OrganizationInfoView)this.organizationInfoViewRepository.findById((Object)id).get();
    }

    @GetMapping(value={"/suggestionsInfo"})
    public SuggestionInfo suggestionsInfo(Authentication authentication) {
        SuggestionInfo info;
        block3: {
            block4: {
                block2: {
                    info = new SuggestionInfo();
                    if (!UserInfo.isSuperAdmin((Authentication)authentication)) break block2;
                    this.suggestionInfoViewByCountryRepository.findAll().forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
                    break block3;
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block3;
            }
            this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().map(arg_0 -> ((SuggestionInfoViewByCountryRepository)this.suggestionInfoViewByCountryRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((SuggestionInfo)info).add(arg_0));
        }
        return info;
    }

    @GetMapping(value={"/get"})
    public OrganizationView findById(@RequestParam String id, Authentication authentication) {
        OrganizationView org = (OrganizationView)this.organizationViewRepository.findById((Object)id).get();
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(org.getCountry(), authentication.getName())) {
            return org;
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/conflicts"})
    public List<OrganizationConflict> conflicts(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName())) {
            return this.databaseUtils.listConflictsForId(id);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/duplicates"})
    public List<OpenaireDuplicateView> duplicates(@RequestParam String id, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName())) {
            return this.openaireDuplicateViewRepository.findByLocalId(id);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/conflicts/byCountry/{country}"})
    public Collection<Set<OrganizationConflict>> findConflictsByCountry(@PathVariable String country, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.groupConflicts(this.conflictGroupViewRepository.findByCountry1OrCountry2(country, country).stream());
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            Stream list = this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().filter(country::equalsIgnoreCase).map(c -> this.conflictGroupViewRepository.findByCountry1OrCountry2(c, c).stream()).findFirst().orElse(Stream.empty());
            return this.groupConflicts(list);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/duplicates/byCountry/{country}"})
    public Iterable<DuplicateGroupView> findDuplicatesByCountry(@PathVariable String country, Authentication authentication) {
        block5: {
            block4: {
                if (UserInfo.isSuperAdmin((Authentication)authentication)) {
                    return this.duplicateGroupViewRepository.findByCountry(country);
                }
                if (UserInfo.isSimpleUser((Authentication)authentication)) break block4;
                if (!UserInfo.isNationalAdmin((Authentication)authentication)) break block5;
            }
            return this.userCountryRepository.getCountriesForUser(authentication.getName()).stream().filter(country::equalsIgnoreCase).map(arg_0 -> ((DuplicateGroupViewRepository)this.duplicateGroupViewRepository).findByCountry(arg_0)).findFirst().orElse(new ArrayList());
        }
        throw new RuntimeException("User not authorized");
    }

    private Collection<Set<OrganizationConflict>> groupConflicts(Stream<ConflictGroupView> stream) {
        TreeMap map = new TreeMap();
        stream.forEach(c -> {
            if (!map.containsKey(c.getGroup())) {
                map.put(c.getGroup(), new TreeSet());
            }
            ((Set)map.get(c.getGroup())).add(new OrganizationConflict(c.getId1(), c.getName1(), c.getType1(), c.getCity1(), c.getCountry1()));
            ((Set)map.get(c.getGroup())).add(new OrganizationConflict(c.getId2(), c.getName2(), c.getType2(), c.getCity2(), c.getCountry2()));
        });
        return map.values();
    }

    @PostMapping(value={"/duplicates"})
    public List<OpenaireDuplicateView> duplicates(@RequestBody List<OpenaireDuplicate> simrels, Authentication authentication) {
        boolean b;
        if (simrels.isEmpty()) {
            return new ArrayList<OpenaireDuplicateView>();
        }
        boolean bl = b = UserInfo.isSuperAdmin((Authentication)authentication) || simrels.stream().map(OpenaireDuplicate::getLocalId).distinct().allMatch(id -> this.userCountryRepository.verifyAuthorizationForId(id, authentication.getName()));
        if (b) {
            this.databaseUtils.saveDuplicates(simrels, authentication.getName());
            return this.openaireDuplicateViewRepository.findByLocalId(simrels.get(0).getLocalId());
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/search/{page}/{size}"})
    public Page<OrganizationSimpleView> search(@PathVariable int page, @PathVariable int size, @RequestParam String q, @RequestParam(required=false, defaultValue="") String status, Authentication authentication) {
        List<String> statuses = StringUtils.isNotBlank((CharSequence)status) ? Arrays.asList(status.split(",")) : (UserInfo.isSimpleUser((Authentication)authentication) ? Arrays.asList(OrganizationStatus.approved.toString()) : Arrays.asList(OrganizationStatus.approved.toString(), OrganizationStatus.suggested.toString()));
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.organizationSimpleViewRepository.search(q, statuses, (Pageable)PageRequest.of((int)page, (int)size)) : this.organizationSimpleViewRepository.searchForUser(q, authentication.getName(), statuses, (Pageable)PageRequest.of((int)page, (int)size));
    }

    @GetMapping(value={"/byCountry/{status}/{code}/{page}/{size}"})
    public Page<OrganizationSimpleView> findByCountry(@PathVariable String status, @PathVariable String code, @PathVariable int page, @PathVariable int size, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(code, authentication.getName())) {
            if (status.equalsIgnoreCase("all")) {
                return this.organizationSimpleViewRepository.findByCountryOrderByName(code, (Pageable)PageRequest.of((int)page, (int)size));
            }
            return this.organizationSimpleViewRepository.findByCountryAndStatusOrderByName(code, status, (Pageable)PageRequest.of((int)page, (int)size));
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/byCountry/{status}/{code}"})
    public Iterable<OrganizationSimpleView> findOrgsByStatusAndCountry(@PathVariable String status, @PathVariable String code, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForCountry(code, authentication.getName())) {
            if (status.equalsIgnoreCase("all")) {
                return this.organizationSimpleViewRepository.findByCountryOrderByName(code);
            }
            return this.organizationSimpleViewRepository.findByCountryAndStatusOrderByName(code, status);
        }
        throw new RuntimeException("User not authorized");
    }

    @GetMapping(value={"/byType/{status}/{type}/{page}/{size}"})
    public Page<OrganizationSimpleView> findByType(@PathVariable String status, @PathVariable String type, @PathVariable int page, @PathVariable int size, Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            if (status.equalsIgnoreCase("all")) {
                return this.organizationSimpleViewRepository.findByTypeOrderByName(type, (Pageable)PageRequest.of((int)page, (int)size));
            }
            return this.organizationSimpleViewRepository.findByTypeAndStatusOrderByName(type, status, (Pageable)PageRequest.of((int)page, (int)size));
        }
        if (status.equalsIgnoreCase("all")) {
            return this.organizationSimpleViewRepository.findByTypeForUser(type, authentication.getName(), (Pageable)PageRequest.of((int)page, (int)size));
        }
        return this.organizationSimpleViewRepository.findByTypeAndStatusForUser(type, status, authentication.getName(), (Pageable)PageRequest.of((int)page, (int)size));
    }

    @GetMapping(value={"/browse/countries"})
    public List<BrowseEntry> browseCountries(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.databaseUtils.browseCountries() : this.databaseUtils.browseCountriesForUser(authentication.getName());
    }

    @GetMapping(value={"/browse/types"})
    public List<BrowseEntry> browseOrganizationTypes(Authentication authentication) {
        return UserInfo.isSuperAdmin((Authentication)authentication) ? this.databaseUtils.browseTypes() : this.databaseUtils.browseTypesForUser(authentication.getName());
    }

    @PostMapping(value={"/conflicts/fix/similar"})
    public List<String> fixConflictSim(Authentication authentication, @RequestBody List<String> ids) {
        if (ids.size() > 1 && UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(ids.get(0), authentication.getName())) {
            String newOrgId = this.databaseUtils.fixConflictSimilars(ids, authentication.getName());
            return Arrays.asList(newOrgId);
        }
        return new ArrayList<String>();
    }

    @PostMapping(value={"/conflicts/fix/different"})
    public List<String> fixConflictDiff(Authentication authentication, @RequestBody List<String> ids) {
        if (ids.size() > 1 && UserInfo.isSuperAdmin((Authentication)authentication) || this.userCountryRepository.verifyAuthorizationForId(ids.get(0), authentication.getName())) {
            this.databaseUtils.fixConflictDifferents(ids, authentication.getName());
            return ids;
        }
        return new ArrayList<String>();
    }
}

