/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.repository.readonly;

import eu.dnetlib.organizations.model.view.OrganizationSimpleView;
import eu.dnetlib.organizations.repository.readonly.ReadOnlyRepository;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrganizationSimpleViewRepository
extends ReadOnlyRepository<OrganizationSimpleView, String> {
    @Query(value="select o.* from organizations_simple_view o left outer join org_index_search idx on (idx.id = o.id) where idx.txt @@ plainto_tsquery(:text) and o.status in :statuses order by o.name", nativeQuery=true)
    public Page<OrganizationSimpleView> search(@Param(value="text") String var1, @Param(value="statuses") List<String> var2, Pageable var3);

    @Query(value="select o.* from organizations_simple_view o left outer join org_index_search idx on (idx.id = o.id) left outer join user_countries uc on (uc.country = o.country) where idx.txt @@ plainto_tsquery(:text) and uc.email = :email and o.status in :statuses order by o.name", nativeQuery=true)
    public Page<OrganizationSimpleView> searchForUser(@Param(value="text") String var1, @Param(value="email") String var2, @Param(value="statuses") List<String> var3, Pageable var4);

    public Page<OrganizationSimpleView> findByCountryOrderByName(String var1, Pageable var2);

    public Iterable<OrganizationSimpleView> findByCountryOrderByName(String var1);

    public Iterable<OrganizationSimpleView> findByCountryAndStatusOrderByName(String var1, String var2);

    public Page<OrganizationSimpleView> findByCountryAndStatusOrderByName(String var1, String var2, Pageable var3);

    public Page<OrganizationSimpleView> findByTypeOrderByName(String var1, Pageable var2);

    public Page<OrganizationSimpleView> findByTypeAndStatusOrderByName(String var1, String var2, Pageable var3);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1 order by o.name", nativeQuery=true)
    public Page<OrganizationSimpleView> findByTypeForUser(String var1, String var2, Pageable var3);

    @Query(value="select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.type = ?1 and o.status = ?2 and uc.email = ?3 order by o.name", nativeQuery=true)
    public Page<OrganizationSimpleView> findByTypeAndStatusForUser(String var1, String var2, String var3, Pageable var4);
}

