/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations;

import eu.dnetlib.organizations.controller.UserRole;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig
extends WebSecurityConfigurerAdapter {
    @Autowired
    private DataSource dataSource;
    @Autowired
    private AccessDeniedHandler accessDeniedHandler;
    @Value(value="${openaire.api.valid.subnet}")
    private String openaireApiValidSubnet;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/", "/api/**"})).hasAnyRole(new String[]{UserRole.ADMIN.name(), UserRole.NATIONAL_ADMIN.name(), UserRole.USER.name()}).antMatchers(new String[]{"/registration_api/**"})).hasRole(UserRole.NOT_AUTHORIZED.name()).antMatchers(new String[]{"/resources/**", "/webjars/**"})).permitAll().antMatchers(new String[]{"/oa_api/**"})).hasIpAddress(this.openaireApiValidSubnet).anyRequest()).authenticated().and()).formLogin().loginPage("/login").permitAll()).and()).logout().permitAll().and()).exceptionHandling().accessDeniedHandler(this.accessDeniedHandler);
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.jdbcAuthentication().dataSource(this.dataSource).usersByUsernameQuery("select ?, '{MD5}60c4a0eb167dd41e915a885f582414df', true").authoritiesByUsernameQuery("with const as (SELECT ? as email) select c.email, 'ROLE_'||coalesce(u.role, '" + UserRole.NOT_AUTHORIZED + "') from const c left outer join users u on (u.email = c.email)");
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }
}

