/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import eu.dnetlib.organizations.utils.RelationType;
import eu.dnetlib.organizations.utils.SimilarityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VocabulariesController {
    @Autowired
    private DatabaseUtils databaseUtils;

    @GetMapping(value={"/api/vocabularies"})
    public Map<String, List<VocabularyTerm>> ListVocabularies(Authentication authentication) {
        HashMap<String, List<VocabularyTerm>> vocs = new HashMap<String, List<VocabularyTerm>>();
        vocs.put("orgTypes", this.databaseUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.org_types));
        vocs.put("idTypes", this.databaseUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.id_types));
        vocs.put("languages", this.databaseUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.languages));
        vocs.put("relTypes", Arrays.stream(RelationType.values()).map(t -> new VocabularyTerm(t.toString(), t.toString())).collect(Collectors.toList()));
        vocs.put("similaritiesType", Arrays.stream(SimilarityType.values()).map(t -> new VocabularyTerm(t.toString(), t.toString())).collect(Collectors.toList()));
        if (UserInfo.isSimpleUser((Authentication)authentication) || UserInfo.isNationalAdmin((Authentication)authentication)) {
            vocs.put("countries", this.databaseUtils.listCountriesForUser(authentication.getName()));
        } else if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            vocs.put("countries", this.databaseUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.countries));
        } else {
            vocs.put("countries", new ArrayList());
        }
        return vocs;
    }

    @GetMapping(value={"/api/voc/allCountries", "/registration_api/voc/allCountries"})
    public List<VocabularyTerm> allCountries() {
        return this.databaseUtils.listValuesOfVocabularyTable(DatabaseUtils.VocabularyTable.countries);
    }
}

