package eu.dnetlib.organizations.controller;

import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.organizations.utils.DatabaseUtils;

@RestController
@RequestMapping("/oa_api")
public class OpenaireInternalApiController {

	@Autowired
	private DatabaseUtils databaseUtils;

	@Value("${openaire.api.https.proxy}")
	private String httpsProxy;

	private static final Log log = LogFactory.getLog(OpenaireInternalApiController.class);

	@GetMapping("/import/dedupEvents")
	public List<String> importDedupEvents(final HttpServletRequest req) {
		if (req.getRemoteAddr().equals(httpsProxy)) {
			log.warn("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr());
			throw new RuntimeException("Call received by blaklisted ip (https proxy): " + req.getRemoteAddr());
		}
		new Thread(databaseUtils::importDedupEvents).start();

		return Arrays.asList("Importing simrels (request from " + req.getRemoteAddr() + ") ...");
	}
}
