package eu.dnetlib.organizations.repository.readonly;

import java.util.List;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import eu.dnetlib.organizations.model.view.OrganizationSimpleView;

@Repository
public interface OrganizationSimpleViewRepository extends ReadOnlyRepository<OrganizationSimpleView, String> {

	// SEARCH
	@Query(value = "select o.* from organizations_simple_view o left outer join org_index_search idx on (idx.id = o.id) where idx.txt @@ plainto_tsquery(:text) and o.status in :statuses order by o.name", nativeQuery = true)
	Page<OrganizationSimpleView> search(@Param("text") String text, @Param("statuses") List<String> statuses, Pageable pageable);

	// SEARCH FOR USER
	@Query(value = "select o.* from organizations_simple_view o left outer join org_index_search idx on (idx.id = o.id) left outer join user_countries uc on (uc.country = o.country) where idx.txt @@ plainto_tsquery(:text) and uc.email = :email and o.status in :statuses order by o.name", nativeQuery = true)
	Page<OrganizationSimpleView> searchForUser(@Param("text") String text,
		@Param("email") String email,
		@Param("statuses") List<String> statuses,
		Pageable pageable);

	Page<OrganizationSimpleView> findByCountryOrderByName(String country, Pageable pageable);

	Iterable<OrganizationSimpleView> findByCountryOrderByName(String code);

	Iterable<OrganizationSimpleView> findByCountryAndStatusOrderByName(String code, String status);

	Page<OrganizationSimpleView> findByCountryAndStatusOrderByName(String code, String status, Pageable pageable);

	Page<OrganizationSimpleView> findByTypeOrderByName(String type, Pageable pageable);

	Page<OrganizationSimpleView> findByTypeAndStatusOrderByName(String type, String status, Pageable pageable);

	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where uc.email = ?2 and o.type = ?1 order by o.name", nativeQuery = true)
	Page<OrganizationSimpleView> findByTypeForUser(String type, String name, Pageable pageable);

	@Query(value = "select o.* from organizations_simple_view o left outer join user_countries uc on (uc.country = o.country) where o.type = ?1 and o.status = ?2 and uc.email = ?3 order by o.name", nativeQuery = true)
	Page<OrganizationSimpleView> findByTypeAndStatusForUser(String type, String status, String name, Pageable pageable);

}
