package eu.dnetlib.organizations.model.view;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import com.vladmihalcea.hibernate.type.json.JsonStringType;

@Entity
@Table(name = "organizations_view")
@TypeDefs({
	@TypeDef(name = "json", typeClass = JsonStringType.class),
	@TypeDef(name = "jsonb", typeClass = JsonBinaryType.class)
})
public class OrganizationView implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -7864607073631041868L;

	@Id
	@Column(name = "id")
	private String id;

	@Column(name = "name")
	private String name;

	@Column(name = "type")
	private String type;

	@Column(name = "lat")
	private Double lat;

	@Column(name = "lng")
	private Double lng;

	@Column(name = "city")
	private String city;

	@Column(name = "country")
	private String country;

	@Type(type = "jsonb")
	@Column(name = "other_ids", columnDefinition = "jsonb")
	private Set<OtherIdentifier> otherIdentifiers;

	@Type(type = "jsonb")
	@Column(name = "other_names", columnDefinition = "jsonb")
	private Set<OtherName> otherNames;

	@Type(type = "jsonb")
	@Column(name = "acronyms", columnDefinition = "jsonb")
	private Set<String> acronyms;

	@Type(type = "jsonb")
	@Column(name = "urls", columnDefinition = "jsonb")
	private Set<String> urls;

	@Type(type = "jsonb")
	@Column(name = "relations", columnDefinition = "jsonb")
	private Set<RelationByOrg> relations;

	@Column(name = "status")
	private String status;

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public Double getLat() {
		return lat;
	}

	public void setLat(final Double lat) {
		this.lat = lat;
	}

	public Double getLng() {
		return lng;
	}

	public void setLng(final Double lng) {
		this.lng = lng;
	}

	public String getCity() {
		return city;
	}

	public void setCity(final String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(final String country) {
		this.country = country;
	}

	public Set<OtherIdentifier> getOtherIdentifiers() {
		return otherIdentifiers;
	}

	public void setOtherIdentifiers(final Set<OtherIdentifier> otherIdentifiers) {
		this.otherIdentifiers = otherIdentifiers;
	}

	public Set<OtherName> getOtherNames() {
		return otherNames;
	}

	public void setOtherNames(final Set<OtherName> otherNames) {
		this.otherNames = otherNames;
	}

	public Set<String> getAcronyms() {
		return acronyms;
	}

	public void setAcronyms(final Set<String> acronyms) {
		this.acronyms = acronyms;
	}

	public Set<String> getUrls() {
		return urls;
	}

	public void setUrls(final Set<String> urls) {
		this.urls = urls;
	}

	public Set<RelationByOrg> getRelations() {
		return relations;
	}

	public void setRelations(final Set<RelationByOrg> relations) {
		this.relations = relations;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(final String status) {
		this.status = status;
	}

}
