/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.organizations.controller;

import eu.dnetlib.organizations.controller.UserInfo;
import eu.dnetlib.organizations.model.utils.VocabularyTerm;
import eu.dnetlib.organizations.model.view.UserView;
import eu.dnetlib.organizations.repository.UserRepository;
import eu.dnetlib.organizations.repository.readonly.UserViewRepository;
import eu.dnetlib.organizations.utils.DatabaseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserController {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserViewRepository userViewRepository;
    @Autowired
    private DatabaseUtils dbUtils;

    @PostMapping(value={"/registration_api/newUser"})
    public Map<String, Integer> newUser(@RequestBody List<String> countries, Authentication authentication) {
        String email = authentication.getName();
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        if (!UserInfo.isNotAuthorized((Authentication)authentication) || this.userRepository.existsById((Object)email)) {
            res.put("status", 2);
        } else {
            this.dbUtils.newUser(email, countries);
            res.put("status", 1);
        }
        return res;
    }

    @GetMapping(value={"/api/users"})
    public Iterable<UserView> users(Authentication authentication) {
        if (UserInfo.isSuperAdmin((Authentication)authentication)) {
            return this.userViewRepository.findAll();
        }
        if (UserInfo.isNationalAdmin((Authentication)authentication)) {
            ArrayList<UserView> res = new ArrayList<UserView>();
            List myCountries = this.dbUtils.listCountriesForUser(authentication.getName()).stream().map(VocabularyTerm::getValue).collect(Collectors.toList());
            for (UserView uw : this.userViewRepository.findAll()) {
                if (uw.getCountries() == null || uw.getCountries().length <= 0 || !myCountries.containsAll(Arrays.asList(uw.getCountries()))) continue;
                res.add(uw);
            }
            return res;
        }
        return new ArrayList<UserView>();
    }

    @PostMapping(value={"/api/users"})
    public Iterable<UserView> save(@RequestBody UserView userView, Authentication authentication) {
        if (authentication.getName().equals(userView.getEmail())) {
            throw new RuntimeException("You can't edit your own user");
        }
        this.dbUtils.saveUser(userView);
        return this.users(authentication);
    }

    @DeleteMapping(value={"/api/users"})
    public Iterable<UserView> delete(@RequestParam String email, Authentication authentication) {
        if (authentication.getName().equals(email)) {
            throw new RuntimeException("You can't delete your own user");
        }
        this.dbUtils.deleteUser(email);
        return this.users(authentication);
    }
}

