/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.scholix.api;

import eu.dnetlib.common.app.AbstractDnetApp;
import eu.dnetlib.scholix.api.MainApplication;
import eu.dnetlib.scholix.api.ScholixAPIConstants;
import eu.dnetlib.scholix.api.TaggedCounter;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication
@EnableCaching
@EnableScheduling
@ComponentScan(basePackages={"eu.dnetlib"})
public class MainApplication
extends AbstractDnetApp {
    private final double scale = 1.0E9;
    private final double[] histogramValues = new double[]{5000000.0, 1.0E7, 2.5E8, 5.0E8, 7.5E8, 1.0E9, 2.5E9, 5.0E9, 7.5E9, 1.0E10};
    @Value(value="${dhp.swagger.api.host}")
    private String swaggetHost;
    @Value(value="${dhp.swagger.api.basePath}")
    private String swaggerPath;

    public static void main(String[] args) {
        SpringApplication.run(MainApplication.class, (String[])args);
    }

    @Bean
    public TaggedCounter myCounter(MeterRegistry meterRegistry) {
        return new TaggedCounter(ScholixAPIConstants.SCHOLIX_MANAGER_COUNTER_NAME, "links", meterRegistry);
    }

    @Bean
    public TimedAspect timedAspect(MeterRegistry meterRegistry) {
        1 mf = new /* Unavailable Anonymous Inner Class!! */;
        meterRegistry.config().meterFilter((MeterFilter)mf);
        return new TimedAspect(meterRegistry);
    }

    @Bean
    public GroupedOpenApi publicApiV1() {
        return GroupedOpenApi.builder().group("Scholexplorer API V1.0").pathsToMatch(new String[]{"/v1/**"}).build();
    }

    @Bean
    public GroupedOpenApi publicApiV2() {
        return GroupedOpenApi.builder().group("Scholexplorer API V2.0").pathsToMatch(new String[]{"/v2/**"}).build();
    }

    protected String swaggerTitle() {
        return "ScholeExplorer APIs";
    }

    protected String swaggerDesc() {
        return ScholixAPIConstants.API_DESCRIPTION;
    }

    static /* synthetic */ double[] access$000(MainApplication x0) {
        return x0.histogramValues;
    }
}

