package eu.dnetlib.actionmanager.actions;

import java.lang.reflect.Type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.actionmanager.common.Agent;
import eu.dnetlib.data.proto.OafProtos.Oaf;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by claudio on 30/09/15.
 */
public class AtomicActionSerialiser extends AbstractActionSerializer implements JsonSerializer<AtomicAction> {

	private static final Log log = LogFactory.getLog(AtomicActionSerialiser.class);

	@Override
	public JsonElement serialize(final AtomicAction aa, final Type typeOfSrc, final JsonSerializationContext context) {

		JsonObject json = new JsonObject();
		json.addProperty(targetColumn, aa.getTargetColumn());
		json.addProperty(targetColumnFamily, aa.getTargetColumnFamily());
		json.addProperty(targetRowKey, aa.getTargetRowKey());
		json.addProperty(rawSet, aa.getRawSet());
		json.addProperty(rowKey, aa.getRowKey());
		json.addProperty(actionType, aa.getActionType().toString());

		json.add(agent, getAgentJSON(aa));

		//json.addProperty(targetValue, getTargetValueJSON(aa));
		json.addProperty(targetValue, Hashing.encodeBase64(getTargetValueJSON(aa)));

		return json;
	}

	private JsonElement getAgentJSON(final AtomicAction aa) {

		final Agent a = aa.getAgent();

		JsonObject json = new JsonObject();
		json.addProperty(agent_id, a.getId());
		json.addProperty(agent_name, a.getName());
		json.addProperty(agent_type, a.getType().toString());

		return json;
	}

	private String getTargetValueJSON(final AtomicAction aa) {
		try {
			return aa.getTargetValue() != null && aa.getTargetValue().length > 0 ? JsonFormat.printToString(Oaf.parseFrom(aa.getTargetValue())) : "";
		} catch (InvalidProtocolBufferException e) {
			log.error("unable to parse proto", e);
			return null;
		}
	}
}

