/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.utils;

import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.XML;

public class JsonUtils {
    private static final Log log = LogFactory.getLog(JsonUtils.class);
    public static final String wrapName = "recordWrap";

    public String syntaxConvertJsonKeyNames(String jsonInput) {
        log.trace((Object)("before convertJsonKeyNames: " + jsonInput));
        while (jsonInput.matches(".*\"([^\"]*)\\s+([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)\\s+([^\"]*)\":", "\"$1_$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)/([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)/([^\"]*)\":", "\"$1_$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)[(]([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)[(]([^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)[)]([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)[)]([^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"][0-9])([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"][0-9])([^\"]*)\":", "\"n_$1$2\":");
        }
        while (jsonInput.matches(".*\"([0-9]+)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([0-9]+)\":", "\"m_$1\":");
        }
        while (jsonInput.matches(".*\"([^\"]*[0-9]):([0-9][^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*[0-9]):([0-9][^\"]*)\":", "\"$1$2\":");
        }
        while (jsonInput.matches(".*\"([^\"]*)=([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"([^\"]*)=([^\"]*)\":", "\"$1-$2\":");
        }
        while (jsonInput.matches(".*\"@([^\"]*)\":.*")) {
            jsonInput = jsonInput.replaceAll("\"@([^\"]*)\":", "\"oat_$1\":");
        }
        log.trace((Object)("after syntaxConvertJsonKeyNames: " + jsonInput));
        return jsonInput;
    }

    public String cleanUnwantedJsonCharsInXmlTagnames(String bufferStr) {
        while (bufferStr.matches(".*<([^<>].*),(.)>.*")) {
            bufferStr = bufferStr.replaceAll("<([^<>.*),(.*)>", "<$1$2>");
        }
        return bufferStr;
    }

    public String convertToXML(String jsonRecord) {
        String resultXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        log.trace((Object)("before convertToXML: " + jsonRecord));
        JSONObject jsonObject = new JSONObject(this.syntaxConvertJsonKeyNames(jsonRecord));
        resultXml = resultXml + XML.toString((Object)jsonObject, (String)wrapName);
        log.trace((Object)("before inputStream: " + resultXml));
        resultXml = XmlCleaner.cleanAllEntities((String)resultXml);
        log.trace((Object)("after cleaning and end of convertToXML: " + resultXml));
        return resultXml;
    }
}

