package eu.dnetlib.data.collector.plugins.researchfi;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class ResearchFiCollectorPlugin extends AbstractCollectorPlugin {

	private static final Log log = LogFactory.getLog(ResearchFiCollectorPlugin.class);

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
		throws CollectorServiceException {

		final String authUrl = interfaceDescriptor.getParams().get("auth_url");
		final String clientId = interfaceDescriptor.getParams().get("auth_client_id");
		final String clientSecret = interfaceDescriptor.getParams().get("auth_client_secret");

		final String authToken = authenticate(authUrl, clientId, clientSecret);

		return () -> new ResearchFiIterator(interfaceDescriptor.getBaseUrl(), authToken);
	}

	private String authenticate(final String authUrl, final String clientId, final String clientSecret) throws CollectorServiceException {
		try (final CloseableHttpClient client = HttpClients.createDefault()) {
			final HttpPost req = new HttpPost(authUrl);
			final List<NameValuePair> params = new ArrayList<>();
			params.add(new BasicNameValuePair("grant_type", "client_credentials"));
			params.add(new BasicNameValuePair("client_id", clientId));
			params.add(new BasicNameValuePair("client_secret", clientSecret));

			req.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));

			try (final CloseableHttpResponse response = client.execute(req)) {
				final String content = IOUtils.toString(response.getEntity().getContent());
				final JSONObject obj = new JSONObject(content);
				final String token = obj.getString("access_token");
				if (StringUtils.isNotBlank(token)) { return token; }
			}
		} catch (final Throwable e) {
			log.warn("Error obtaining access token", e);
			throw new CollectorServiceException("Error obtaining access token", e);
		}
		throw new CollectorServiceException("Access token is missing");

	}

}
