/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.eosc;

import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.dom4j.Document;
import org.dom4j.Element;
import org.json.JSONObject;

public class EoscServicesPlugin
extends AbstractCollectorPlugin {
    private static final Log log = LogFactory.getLog(EoscServicesPlugin.class);

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        long quantity = NumberUtils.toLong((String)((String)interfaceDescriptor.getParams().get("quantity")), (long)10000L);
        String type = (String)interfaceDescriptor.getParams().get("type");
        String authorizationUrl = (String)interfaceDescriptor.getParams().get("authorizationUrl");
        String clientId = (String)interfaceDescriptor.getParams().get("clientId");
        String refreshToken = (String)interfaceDescriptor.getParams().get("refreshToken");
        String accessToken = this.obtainAccessoToken(authorizationUrl, clientId, refreshToken);
        String urlOrgs = baseUrl + "/provider/bundle/all?quantity=" + quantity;
        String urlServices = baseUrl + "/service/adminPage/all?quantity=" + quantity;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            urlServices = urlServices + "&type=" + type.trim();
        }
        Iterator<String> iter1 = this.iterCall(urlOrgs, accessToken, "organization");
        Iterator<String> iter2 = this.iterCall(urlServices, accessToken, "service");
        return () -> Iterators.concat((Iterator)iter1, (Iterator)iter2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String obtainAccessoToken(String url, String clientId, String refreshToken) throws CollectorServiceException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost req = new HttpPost(url);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("grant_type", "refresh_token"));
            params.add(new BasicNameValuePair("refresh_token", refreshToken));
            params.add(new BasicNameValuePair("client_id", clientId));
            params.add(new BasicNameValuePair("scope", "openid email profile"));
            req.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JSONObject obj = new JSONObject(content);
                String token = obj.getString("access_token");
                if (!StringUtils.isNotBlank((CharSequence)token)) throw new CollectorServiceException("Access token is missing");
                String string = token;
                return string;
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error obtaining access token", e);
            throw new CollectorServiceException("Error obtaining access token", e);
        }
    }

    private Iterator<String> iterCall(String url, String token, String type) {
        return this.httpCall(url, token).selectNodes("//results/results").stream().map(o -> {
            Element el = (Element)o;
            el.addAttribute("type", type);
            return el.asXML();
        }).iterator();
    }

    /*
     * Exception decompiling
     */
    private Document httpCall(String url, String token) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

