/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.fairsharing;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.json.JSONObject;
import org.json.XML;

public class FairSharingIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(FairSharingIterator.class);
    private final Queue<String> queue = new PriorityBlockingQueue<String>();
    private final String baseUrl;
    private final String authCode;
    private final int pageSize;
    private final Map<String, Element> savedOrgs;
    private String nextUrl;
    private boolean started;

    public FairSharingIterator(String baseUrl, String authCode, int pageSize) {
        this.baseUrl = baseUrl;
        this.authCode = authCode;
        this.pageSize = pageSize;
        this.started = false;
        this.savedOrgs = new HashMap<String, Element>();
    }

    private void verifyStarted() {
        if (!this.started) {
            this.started = true;
            try {
                String url = this.baseUrl + "/fairsharing_records/?page%5Bnumber%5D=1&page%5Bsize%5D=" + this.pageSize;
                this.nextUrl = this.downloadPage(url);
            }
            catch (CollectorServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.nextUrl != null && !this.nextUrl.isEmpty()) {
                try {
                    this.nextUrl = this.downloadPage(this.nextUrl);
                }
                catch (CollectorServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return res;
        }
    }

    @Override
    public void remove() {
    }

    /*
     * Exception decompiling
     */
    private String downloadPage(String url) throws CollectorServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addOrganizationInfo(Element n) throws CollectorServiceException {
        String orgId = n.valueOf("./organisation_id");
        if (!this.savedOrgs.containsKey(orgId)) {
            String url = this.baseUrl + "/organisations/" + orgId;
            HttpGet req = new HttpGet(url);
            req.addHeader("Accept", "application/json");
            req.addHeader("Content-Type", "application/json");
            req.addHeader("Authorization", "Bearer " + this.authCode);
            try (CloseableHttpClient client = HttpClients.createDefault();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JSONObject obj = new JSONObject(content);
                Document doc = DocumentHelper.parseText((String)XML.toString((Object)obj.getJSONObject("data"), (String)"extended_info"));
                for (Object o : doc.selectNodes("//organisation_links")) {
                    ((Node)o).detach();
                }
                this.fix_null_values(doc);
                this.savedOrgs.put(orgId, doc.getRootElement());
            }
            catch (Exception e) {
                throw new CollectorServiceException("Error perfoming call for organization", (Throwable)e);
            }
        }
        n.add(this.savedOrgs.get(orgId).createCopy());
    }

    private void fix_null_values(Document doc) {
        for (Object o : doc.selectNodes("//*[text() = 'null']")) {
            ((Element)o).setText("");
        }
    }
}

