package eu.dnetlib.swagger.configuration;

import eu.dnetlib.common.rmi.DNetRestDocumentation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerDocumentationConfig {

    @Value("${api.rest.contact.name}")
    private String contactName;

    @Value("${api.rest.contact.url}")
    private String contactUrl;

    @Value("${api.rest.contact.email}")
    private String contactEmail;

	@Value("${api.rest.title}")
	private String title;

	@Value("${api.rest.description}")
	private String description;

	@Value("${api.rest.license}")
	private String license;
	@Value("${api.rest.license.url}")
	private String licenseUrl;

    @Bean
    public Docket customImplementation(){
        return new Docket(DocumentationType.SWAGGER_2)
                .select()
			        //.apis(RequestHandlerSelectors.any())
                    //.apis(RequestHandlerSelectors.basePackage("eu.dnetlib.**.controller.*"))
		            //.apis(RequestHandlerSelectors.withClassAnnotation(RestController.class))
		            .apis(RequestHandlerSelectors.withClassAnnotation(DNetRestDocumentation.class))
                    //.paths(PathSelectors.ant("/ds/**"))
                    .build()
                .directModelSubstitute(org.joda.time.LocalDate.class, java.sql.Date.class)
                .directModelSubstitute(org.joda.time.DateTime.class, java.util.Date.class)
                .apiInfo(apiInfo());
    }

	private ApiInfo apiInfo() {
		return new ApiInfoBuilder()
				.title(title)
				.description(description)
				.license(license)
				.licenseUrl(licenseUrl)
				.termsOfServiceUrl("")
				.version("1.0.0")
				.contact(new Contact(contactName, contactUrl, contactEmail))
				.build();
	}

}
