package eu.dnetlib.data.transformation.service;

import javax.xml.transform.TransformerConfigurationException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

import eu.dnetlib.common.profile.ProfileNotFoundException;
import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.VocabularyRegistry;
import eu.dnetlib.data.collective.transformation.engine.SimpleTransformationEngine;
import eu.dnetlib.data.collective.transformation.engine.core.TransformationImpl;
import eu.dnetlib.data.collective.transformation.utils.TransformationRulesImportTool;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.miscutils.functional.UnaryFunction;

public class SimpleDataTransformer implements UnaryFunction<String, String> {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SimpleDataTransformer.class);

	/**
	 * Transformation rule profile
	 */
	private String ruleProfile;
	private SimpleTransformationEngine transformationEngine;

	public SimpleDataTransformer(final String ruleProfile) {
		this.ruleProfile = ruleProfile;

		// TODO
		// instantiate here the xml transformer

		if (log.isDebugEnabled()) {
			log.debug("************************************************************");
			log.debug("New transformer created from profile " + ruleProfile);
			log.debug("************************************************************");
		}

	}

	@Override
	public String evaluate(final String record) {
		if (log.isDebugEnabled()) {
			log.debug("************************************************************");
			log.debug("INPUT: " + record);
			log.debug("************************************************************");
		}

		final String output = transform(record);

		if (log.isDebugEnabled()) {
			log.debug("************************************************************");
			log.debug("OUTPUT: " + output);
			log.debug("************************************************************");
		}

		return output;
	}

	private String transform(final String record) {
		// use here the xml transformer
		return transformationEngine.transform(record);
	}

	protected void setupEngine(final VocabularyRegistry vocabularyRegistry,
		final Resource transformationTemplate,
		final Resource defaultSchema,
		final TransformationRulesImportTool rulesProfileUtil,
		final ResourceDao resourceDao,
		final Resource blacklistApi,
		final LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager) throws TransformerConfigurationException, ProfileNotFoundException {
		transformationEngine = new SimpleTransformationEngine();
		transformationEngine.setVocabularyRegistry(vocabularyRegistry);
		transformationEngine.setDsManager(dsManager);
		final TransformationImpl transformation = new TransformationImpl();
		transformation.setSchema(defaultSchema);
		transformation.setTemplate(transformationTemplate);
		transformation.init();
		if (log.isDebugEnabled()) {
			log.debug("************************************************************");
			log.debug(ruleProfile);
			log.debug("************************************************************");
		}
		transformation.setRuleLanguageParser(rulesProfileUtil.getRuleLanguageParser(ruleProfile));
		transformation.configureTransformation();
		transformationEngine.setTransformation(transformation);
		transformationEngine.setResourceDao(resourceDao);
		transformationEngine.setBlacklistApi(blacklistApi);
	}

	public String getRuleProfile() {
		return ruleProfile;
	}

	public void setRuleProfile(final String ruleProfile) {
		this.ruleProfile = ruleProfile;
	}

}
