/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop;

import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopBlackboardActions;
import eu.dnetlib.data.hadoop.rmi.HadoopJobType;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubmitHadoopJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(SubmitHadoopJobNode.class);
    public static final String OOZIE_REPORT_ACTIONS = "oozie.report.actions.csv";
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String hadoopJob;
    private String cluster;
    private boolean simulation = false;
    private String oozieReportActionsCsv;

    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(HadoopService.class);
    }

    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        String type = this.getJobType(this.getHadoopJob());
        log.info((Object)("submitting job " + this.getHadoopJob() + " type: " + type));
        job.setAction(type);
        job.getParameters().put("job.name", this.getHadoopJob());
        job.getParameters().put("cluster", this.cluster(token));
        job.getParameters().put("simulation", String.valueOf(this.isSimulation()));
        if (StringUtils.isNotBlank((String)this.getOozieReportActionsCsv())) {
            log.info((Object)("enabling oozie job report, param(s): " + this.getOozieReportActionsCsv()));
            job.getParameters().put(OOZIE_REPORT_ACTIONS, this.getOozieReportActionsCsv());
        } else {
            log.warn((Object)"couldn't find param to enable oozie job report!");
        }
        job.getParameters().putAll(this.parseJsonParameters(token));
    }

    private String cluster(NodeToken token) {
        if (token.getEnv().hasAttribute("cluster")) {
            String cluster = token.getEnv().getAttribute("cluster");
            log.info((Object)("found override value in wfEnv for 'cluster' param: " + cluster));
            return cluster;
        }
        return this.getCluster();
    }

    private String getJobType(String jobName) throws ISLookUpException {
        List res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("/RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'HadoopJobConfigurationDSResourceType']//HADOOP_JOB[./@name='" + jobName + "']/@type/string()");
        if (res.isEmpty()) {
            throw new IllegalStateException("unable to find job type for job: " + jobName);
        }
        HadoopJobType type = HadoopJobType.valueOf((String)((String)Iterables.getOnlyElement((Iterable)res)));
        switch (type) {
            case mapreduce: {
                return HadoopBlackboardActions.SUBMIT_MAPREDUCE_JOB.toString();
            }
            case admin: {
                return HadoopBlackboardActions.SUBMIT_ADMIN_JOB.toString();
            }
            case oozie: {
                return HadoopBlackboardActions.SUBMIT_OOZIE_JOB.toString();
            }
        }
        throw new IllegalStateException("undefined job type: " + type.toString());
    }

    public String getHadoopJob() {
        return this.hadoopJob;
    }

    public void setHadoopJob(String hadoopJob) {
        this.hadoopJob = hadoopJob;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public String getOozieReportActionsCsv() {
        return this.oozieReportActionsCsv;
    }

    public void setOozieReportActionsCsv(String oozieReportActionsCsv) {
        this.oozieReportActionsCsv = oozieReportActionsCsv;
    }
}

