package eu.dnetlib.msro.workflows.dedup;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class CheckDoneJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(CheckDoneJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String param;

	private String exitArc;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		if (StringUtils.isBlank(getParam())) throw new MSROException("cannot find param name, please set it on the workflow definition");

		final String simRels = token.getFullEnv().getAttribute(getParam());
		if (StringUtils.isBlank(simRels))
			throw new MSROException(String.format("cannot find param '%s' in workflow env", getParam()));

		if (Integer.parseInt(simRels) > 0) {
			log.info(String.format("found %s %s, continue with the next iteration", simRels, getParam()));
			return getExitArc();
		}
		log.info(String.format("found %s %s, done", simRels, getParam()));

		return Arc.DEFAULT_ARC;
	}

	public String getParam() {
		return param;
	}

	public void setParam(final String param) {
		this.param = param;
	}

	public String getExitArc() {
		return exitArc;
	}

	public void setExitArc(final String exitArc) {
		this.exitArc = exitArc;
	}

}
