/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.pace.config.DedupConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupConfigurationAwareJobNode
extends SubmitHadoopJobNode {
    private static final Log log = LogFactory.getLog(DedupConfigurationAwareJobNode.class);
    private String dedupConfigSequenceParam;

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        super.prepareJob(job, token);
        DedupConfigurationOrchestration dedupConfigurations = this.dedupConfigurations(token);
        DedupConfig currentConf = dedupConfigurations.getConfigurations().peek();
        log.debug((Object)("using dedup configuration: '" + currentConf + "'"));
        job.getParameters().put("dedup.conf", currentConf.toString());
        token.getEnv().setAttribute("dedup.conf", currentConf.toString());
    }

    protected DedupConfigurationOrchestration dedupConfigurations(NodeToken token) {
        String configs = token.getFullEnv().getAttribute(this.getDedupConfigSequenceParam());
        if (configs == null || configs.trim().isEmpty()) {
            throw new IllegalStateException("Cannot find dedup configurations in workflow env: '" + this.getDedupConfigSequenceParam() + "'");
        }
        return DedupConfigurationOrchestration.fromJSON(configs);
    }

    protected String getEntityType(NodeToken token) {
        String entityType = token.getEnv().getAttribute("entityType");
        if (StringUtils.isBlank((String)entityType)) {
            throw new IllegalStateException("Cannot find 'entityType' parameter in workflow env.");
        }
        return entityType;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }
}

