package eu.dnetlib.functionality.modular.ui.dedup;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import eu.dnetlib.data.dedup.DedupUserActionsDAO;
import eu.dnetlib.data.dedup.OafResult;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;

@Controller
public class DedupServiceInternalController extends AbstractAjaxController {

	private static final Log log = LogFactory.getLog(DedupServiceInternalController.class);

	@Autowired
	private DedupUserActionsDAO dedupDao;

	@ResponseBody
	@RequestMapping(value = "/ui/dedup/lookupConfigurations.do")
	public Map<String, List<String>> lookupConfigurations() throws Exception {
		try {
			return dedupDao.listConfigurations();
		} catch (final Exception e) {
			log.error("unable to lookup configurations error", e);
			throw e;
		}
	}

	@ResponseBody
	@RequestMapping(value = "/ui/dedup/search.do")
	public OafResult search(@RequestParam(value = "entityType", required = true) final String type,
			@RequestParam(value = "query", required = true) final String userQuery,
			@RequestParam(value = "actionSet", required = true) final String actionSet,
			@RequestParam(value = "start", required = true) final int start,
			@RequestParam(value = "rows", required = true) final int rows,
			@RequestParam(value = "fields", required = true) final String fields) throws Exception {
		try {
			return dedupDao.search(type, userQuery, actionSet, start, rows, fields);
		} catch (final Exception e) {
			log.error("search error", e);
			throw e;
		}
	}

	@ResponseBody
	@RequestMapping(value = "/ui/dedup/searchById.do")
	public OafResult searchById(@RequestParam(value = "actionSet", required = true) final String actionSet,
			@RequestParam(value = "entityType", required = true) final String type,
			@RequestParam(value = "objidentifier", required = true) final String objidentifier,
			@RequestParam(value = "fields", required = true) final List<String> fields) throws Exception {
		try {
			return dedupDao.searchById(actionSet, type, objidentifier, fields);
		} catch (final Exception e) {
			log.error("search error", e);
			throw e;
		}

	}

	@ResponseBody
	@RequestMapping(value = "/ui/dedup/commit.do")
	public boolean addSimRels(@RequestBody(required = true) final SimilarityGroup group) throws Exception {
		try {
			return dedupDao.commit(group);
		} catch (final Exception e) {
			log.error("commit error", e);
			throw e;
		}
	}

}
