package eu.dnetlib.msro.workflows.hadoop.hbase;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.hadoop.rmi.HadoopService;

public class GetHBaseTableDescriptionJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(GetHBaseTableDescriptionJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("getting table description: '" + tableName + "' on cluster: '" + cluster + "'");

		final List<String> columns = getServiceLocator().getService(HadoopService.class).describeHbaseTable(cluster, tableName);
		log.debug(String.format("table '%s': " + columns, tableName));
		token.getEnv().setAttribute(getTableColumnsParamName(), asCSV(columns));

		return Arc.DEFAULT_ARC;
	}

}
