/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.dedup;

import com.google.common.collect.Maps;
import eu.dnetlib.data.dedup.AbstractDedupDAO;
import eu.dnetlib.data.dedup.DedupDbDAO;
import eu.dnetlib.data.dedup.DedupIndexDAO;
import eu.dnetlib.data.dedup.DedupUserActionsDAO;
import eu.dnetlib.data.dedup.OafResult;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupUserActionsDAOImpl
extends AbstractDedupDAO
implements DedupUserActionsDAO {
    private static final Log log = LogFactory.getLog(DedupUserActionsDAOImpl.class);
    @Autowired
    private DedupDbDAO dbDAO;
    @Autowired
    private DedupIndexDAO indexDAO;

    @Override
    public Map<String, List<String>> listConfigurations() throws ISLookUpException {
        HashMap res = Maps.newHashMap();
        ISLookUpService lookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String listEntityTypesXQuery = "distinct-values(for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//CONFIGURATION/@enabled='true'] return $x//ENTITY/@name/string())";
        for (String entityType : lookUpService.quickSearchProfile("distinct-values(for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//CONFIGURATION/@enabled='true'] return $x//ENTITY/@name/string())")) {
            String xquery = String.format("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ENTITY/@name='%s' ] return $x//ACTION_SET/@id/string()", entityType);
            res.put(entityType, lookUpService.quickSearchProfile(xquery));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("found configurations: " + res));
        }
        return res;
    }

    @Override
    public OafResult search(String type, String userQuery, String actionSet, int start, int rows, String fields) throws Exception {
        return this.indexDAO.search(type, userQuery, actionSet, start, rows, fields);
    }

    @Override
    public OafResult searchById(String actionSet, String type, String objidentifier, List<String> fields) throws Exception {
        return this.indexDAO.searchById(actionSet, type, objidentifier, fields);
    }

    @Override
    public boolean commit(SimilarityGroup group) throws Exception {
        if (StringUtils.isBlank((String)group.getActionSet())) {
            throw new IllegalArgumentException("missing actionset");
        }
        group.setId(UUID.randomUUID().toString());
        group.setDate(InputDocumentFactory.getParsedDateField((String)DateUtils.now_ISO8601()));
        return this.dbDAO.commit(group) && this.indexDAO.commit(group);
    }
}

