/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.DedupConfigurationAwareJobNode;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupDuplicateScanJobNode
extends DedupConfigurationAwareJobNode {
    private static final Log log = LogFactory.getLog(DedupDuplicateScanJobNode.class);

    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new DedupBlackboardWorkflowJobListener(engine, token);
    }

    private class DedupBlackboardWorkflowJobListener
    extends BlackboardWorkflowJobListener {
        public DedupBlackboardWorkflowJobListener(Engine engine, NodeToken token) {
            super(engine, token);
        }

        protected void onDone(BlackboardJob job) {
            DedupConfigurationOrchestration confs = DedupDuplicateScanJobNode.this.dedupConfigurations(this.getToken());
            confs.getConfigurations().poll();
            log.info((Object)("checking dedup configs queue, size: " + confs.getConfigurations().size()));
            if (CollectionUtils.isEmpty(confs.getConfigurations())) {
                log.info((Object)"dedup similarity scan done");
                super.complete(job, "done");
            } else {
                log.debug((Object)("remaining confs: " + confs));
                this.getToken().getEnv().setAttribute(DedupDuplicateScanJobNode.this.getDedupConfigSequenceParam(), confs.toString());
                super.complete(job, Arc.DEFAULT_ARC);
            }
        }
    }
}

