package eu.dnetlib.data.dedup;

import java.util.List;
import java.util.Map;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;

/**
 * The Interface DedupUserActionsDAO.
 */
public interface DedupUserActionsDAO {

	/**
	 * Search on the Dedup index.
	 *
	 * @param type
	 *            the type
	 * @param userQuery
	 *            the user query
	 * @param actionSet
	 *            the action set
	 * @param start
	 *            the start
	 * @param rows
	 *            the rows
	 * @param fields
	 *            the fields
	 * @return the oaf result
	 * @throws Exception
	 *             the exception
	 */
	OafResult search(String type, String userQuery, String actionSet, int start, int rows, String fields) throws Exception;

	/**
	 * Search by id on the dedup index.
	 *
	 * @param actionSet
	 *            the action set
	 * @param type
	 *            the type
	 * @param objidentifier
	 *            the objidentifier
	 * @param fields
	 *            the fields
	 * @return the oaf result
	 * @throws Exception
	 *             the exception
	 */
	OafResult searchById(String actionSet, String type, String objidentifier, List<String> fields) throws Exception;

	/**
	 * Commit the changes on the dedup index.
	 *
	 * @param group
	 *            the group
	 * @return true, if successful
	 * @throws Exception
	 *             the exception
	 */
	boolean commit(SimilarityGroup group) throws Exception;

	/**
	 * List dedup configurations defined in the information system.
	 *
	 * @return the map
	 * @throws ISLookUpException
	 *             the IS look up exception
	 */
	Map<String, List<String>> listConfigurations() throws ISLookUpException;

}
