package eu.dnetlib.msro.workflows.dedup;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;

public class DedupGrouperJobNode extends DedupConfigurationAwareJobNode {

	// TODO factor out this constant, it should be a configuration parameter
	public static final int DEDUP_GROUPER_MAX_LOOPS = 10;

	public static final String DEDUP_GROUPER_LOOPER = "dedup.grouper.looper";
	public static final String DEDUP_GROUPER_CURR_WRITTEN_RELS = "dedup.grouper.written.rels";
	public static final String DEDUP_GROUPER_PREV_WRITTEN_RELS = "dedup.grouper.prev.written.rels";

	private static final Log log = LogFactory.getLog(DedupGrouperJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private class DedupBlackboardWorkflowJobListener extends BlackboardWorkflowJobListener {

		public DedupBlackboardWorkflowJobListener(final Engine engine, final NodeToken token) {
			super(engine, token);
		}

		@Override
		protected void onDone(final BlackboardJob job) {

			final int times = currentIteration(getToken());
			final String curr = job.getParameters().get(DEDUP_GROUPER_CURR_WRITTEN_RELS);

			if (times == 0) {
				getToken().getFullEnv().setAttribute(DEDUP_GROUPER_PREV_WRITTEN_RELS, -1);
			}

			if ((times >= DEDUP_GROUPER_MAX_LOOPS) || isStable(getToken(), curr)) {
				super.complete(job, "done");
			} else {
				log.info("incrementing dedup.grouper.looper to " + (times + 1));
				getToken().getFullEnv().setAttribute(DEDUP_GROUPER_LOOPER, times + 1);
				getToken().getFullEnv().setAttribute(DEDUP_GROUPER_PREV_WRITTEN_RELS, curr);
				super.complete(job, Arc.DEFAULT_ARC);
			}
		}
	}

	private int currentIteration(final NodeToken token) {
		try {
			final String sTimes = token.getFullEnv().getAttribute(DEDUP_GROUPER_LOOPER);
			log.info("read dedup.grouper.looper from fullEnv: '" + sTimes + "'");
			return Integer.parseInt(sTimes);
		} catch (final NumberFormatException e) {
			log.info("got empty dedup.grouper.looper, initializing to 0");
			return 0;
		}
	}

	private boolean isStable(final NodeToken token, final String sCurr) {
		final String sPrev = token.getFullEnv().getAttribute(DEDUP_GROUPER_PREV_WRITTEN_RELS);

		log.info("Comparing written rels, prev=" + sPrev + ", curr=" + sCurr);
		try {
			final boolean b = Integer.parseInt(sCurr) == Integer.parseInt(sPrev);
			if (b) {
				log.info("  --- The number of written rels is STABLE");
			}
			return b;
		} catch (final Exception e) {
			log.error("Invalid parsing of written rels counters - curr: " + sCurr + ", prev: " + sPrev);
			return false;
		}
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Engine engine, final NodeToken token) {
		return new DedupBlackboardWorkflowJobListener(engine, token);
	}

}
