/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.dedup;

import eu.dnetlib.data.dedup.DedupUserActionsDAO;
import eu.dnetlib.data.dedup.OafResult;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DedupServiceInternalController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(DedupServiceInternalController.class);
    @Autowired
    private DedupUserActionsDAO dedupDao;

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/lookupConfigurations.do"})
    public Map<String, List<String>> lookupConfigurations() throws Exception {
        try {
            return this.dedupDao.listConfigurations();
        }
        catch (Exception e) {
            log.error((Object)"unable to lookup configurations error", (Throwable)e);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/search.do"})
    public OafResult search(@RequestParam(value="entityType", required=true) String type, @RequestParam(value="query", required=true) String userQuery, @RequestParam(value="actionSet", required=true) String actionSet, @RequestParam(value="start", required=true) int start, @RequestParam(value="rows", required=true) int rows, @RequestParam(value="fields", required=true) String fields) throws Exception {
        try {
            return this.dedupDao.search(type, userQuery, actionSet, start, rows, fields);
        }
        catch (Exception e) {
            log.error((Object)"search error", (Throwable)e);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/searchById.do"})
    public OafResult searchById(@RequestParam(value="actionSet", required=true) String actionSet, @RequestParam(value="entityType", required=true) String type, @RequestParam(value="objidentifier", required=true) String objidentifier, @RequestParam(value="fields", required=true) List<String> fields) throws Exception {
        try {
            return this.dedupDao.searchById(actionSet, type, objidentifier, fields);
        }
        catch (Exception e) {
            log.error((Object)"search error", (Throwable)e);
            throw e;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/ui/dedup/commit.do"})
    public boolean addSimRels(@RequestBody(required=true) SimilarityGroup group) throws Exception {
        try {
            return this.dedupDao.commit(group);
        }
        catch (Exception e) {
            log.error((Object)"commit error", (Throwable)e);
            throw e;
        }
    }
}

