package eu.dnetlib.data.dedup;

import java.util.List;
import java.util.Map;

/**
 * OafResult maps the results got from the dedup index.
 */
public class OafResult {

	/** The total. */
	private long total;

	/** The results. */
	private List<Map<String, String>> results;

	/**
	 * Instantiates a new oaf result.
	 *
	 * @param total
	 *            the total
	 * @param results
	 *            the results
	 */
	public OafResult(final long total, final List<Map<String, String>> results) {
		super();
		this.setTotal(total);
		this.setResults(results);
	}

	/**
	 * Gets the total.
	 *
	 * @return the total
	 */
	public long getTotal() {
		return total;
	}

	/**
	 * Sets the total.
	 *
	 * @param total
	 *            the new total
	 */
	public void setTotal(final long total) {
		this.total = total;
	}

	/**
	 * Gets the results.
	 *
	 * @return the results
	 */
	public List<Map<String, String>> getResults() {
		return results;
	}

	/**
	 * Sets the results.
	 *
	 * @param results
	 *            the results
	 */
	public void setResults(final List<Map<String, String>> results) {
		this.results = results;
	}
}
