package eu.dnetlib.msro.workflows.hadoop.hbase;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class SetHBaseTableJobNode extends SimpleJobNode {

	private String tableProperty = "hbaseTable";

	private String table;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		token.getEnv().setAttribute(getTableProperty(), getTable());
		return Arc.DEFAULT_ARC;
	}

	public String getTableProperty() {
		return tableProperty;
	}

	public void setTableProperty(final String tableProperty) {
		this.tableProperty = tableProperty;
	}

	public String getTable() {
		return table;
	}

	public void setTable(final String table) {
		this.table = table;
	}

}
