/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dnetexploremetrics.service;

import eu.dnetlib.dnetexploremetrics.dao.MetricsDAO;
import eu.dnetlib.dnetexploremetrics.model.Metrics;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@EnableScheduling
@Service
public class MetricsService {
    private final Logger logger = Logger.getLogger(this.getClass());
    @Autowired
    private MetricsDAO metricsDAO;
    @Value(value="${search.service.api.url:https://services.openaire.eu/search/v2/api/}")
    private String searchUrl;
    private final String recordsRequest = "results?size=0&format=json";
    private final String publicationsRequest = "publications?size=0&format=json";
    private final String datasetsRequest = "datasets?size=0&format=json";
    private final String softwareRequest = "software?size=0&format=json";
    private final String orpRequest = "other?size=0&format=json";
    private final String fundersRequest = "resources2?format=json&refine=true&fields=relfunder&type=results&page=0&size=0";
    private final String projectsRequest = "projects?size=0&format=json";
    private final String contentProvidersRequest = "datasources?size=0&format=json";
    private final String organizationsRequest = "resources2?query=((reldatasourcecompatibilityid exact driver or reldatasourcecompatibilityid exact driver-openaire2.0 or reldatasourcecompatibilityid exact openaire2.0 or reldatasourcecompatibilityid exact openaire3.0 or reldatasourcecompatibilityid exact openaire4.0 or reldatasourcecompatibilityid exact openaire-cris_1.1 or reldatasourcecompatibilityid exact openaire2.0_data or reldatasourcecompatibilityid exact hostedBy or relproject=*))&type=organizations&size=0&format=json";

    @Scheduled(cron="${calculation.time.cron}")
    private void calculateMetrics() {
        this.logger.info((Object)"Calculating metrics...");
        Metrics metrics = new Metrics();
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.getForEntity(this.searchUrl + "results?size=0&format=json", String.class, new Object[0]);
        JSONObject jsonObject = new JSONObject((String)response.getBody());
        metrics.records = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "publications?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.publications = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "datasets?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.datasets = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "software?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.software = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "other?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.orp = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "resources2?format=json&refine=true&fields=relfunder&type=results&page=0&size=0", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.funders = jsonObject.getJSONObject("refineResults").getJSONArray("relfunder").length() + "";
        response = restTemplate.getForEntity(this.searchUrl + "projects?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.projects = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "datasources?size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.contentProviders = jsonObject.getJSONObject("meta").get("total").toString();
        response = restTemplate.getForEntity(this.searchUrl + "resources2?query=((reldatasourcecompatibilityid exact driver or reldatasourcecompatibilityid exact driver-openaire2.0 or reldatasourcecompatibilityid exact openaire2.0 or reldatasourcecompatibilityid exact openaire3.0 or reldatasourcecompatibilityid exact openaire4.0 or reldatasourcecompatibilityid exact openaire-cris_1.1 or reldatasourcecompatibilityid exact openaire2.0_data or reldatasourcecompatibilityid exact hostedBy or relproject=*))&type=organizations&size=0&format=json", String.class, new Object[0]);
        jsonObject = new JSONObject((String)response.getBody());
        metrics.organizations = jsonObject.getJSONObject("meta").get("total").toString();
        this.metricsDAO.save(metrics);
    }

    public String getMetrics() {
        return this.metricsDAO.getMetrics();
    }
}

