/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.remotemdstore;

import com.google.common.collect.Iterables;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

public class RemoteMdStoreIterator
implements Iterator<String> {
    private static final String COLL_METADATA_MANAGER = "metadataManager";
    private static final Log log = LogFactory.getLog(RemoteMdStoreIterator.class);
    private final MongoClient client;
    private final MongoDatabase db;
    private final Iterator<String> innerIterator;

    public RemoteMdStoreIterator(String baseUrl, String dbName, String mdId) throws CollectorServiceException {
        this.client = new MongoClient(new MongoClientURI(baseUrl));
        this.db = this.getDb(this.client, dbName);
        this.innerIterator = this.getMdstoreColl(this.db, mdId).find().map(doc -> doc.getString((Object)"body")).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.innerIterator.hasNext();
    }

    @Override
    public String next() {
        try {
            String string = this.innerIterator.next();
            return string;
        }
        finally {
            if (!this.innerIterator.hasNext()) {
                log.info((Object)"Mongo Client correctly closed");
                this.client.close();
            }
        }
    }

    private MongoDatabase getDb(MongoClient client, String dbName) throws CollectorServiceException {
        if (!Iterables.contains((Iterable)client.listDatabaseNames(), (Object)dbName)) {
            String err = String.format("Database '%s' not found in %s", dbName, client.getAddress());
            log.warn((Object)err);
            throw new CollectorServiceException(err);
        }
        return client.getDatabase(dbName);
    }

    private MongoCollection<Document> getColl(MongoDatabase db, String collName) throws CollectorServiceException {
        if (!Iterables.contains((Iterable)db.listCollectionNames(), (Object)collName)) {
            String err = String.format(String.format("Missing collection '%s' in database '%s'", collName, db.getName()), new Object[0]);
            log.warn((Object)err);
            throw new CollectorServiceException(err);
        }
        return db.getCollection(collName);
    }

    private MongoCollection<Document> getMdstoreColl(MongoDatabase db, String mdId) throws CollectorServiceException {
        MongoCollection<Document> collManager = this.getColl(db, COLL_METADATA_MANAGER);
        for (Document entry : collManager.find()) {
            if (!entry.getString((Object)"mdId").equals(mdId) || !StringUtils.isNotBlank((CharSequence)entry.getString((Object)"currentId"))) continue;
            return this.getColl(db, entry.getString((Object)"currentId"));
        }
        throw new CollectorServiceException("Mdstore not found in metadataManager");
    }
}

