/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.remotemdstore;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.remotemdstore.RemoteMdStoreIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import org.apache.commons.lang3.StringUtils;

public class RemoteMdstorePlugin
extends AbstractCollectorPlugin {
    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String dbName = (String)interfaceDescriptor.getParams().get("remote_database");
        String mdId = (String)interfaceDescriptor.getParams().get("remote_mdstore_id");
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new CollectorServiceException("Invalid baseUrl, example: mongodb://[username:password@]host[:port]");
        }
        if (StringUtils.isBlank((CharSequence)dbName)) {
            throw new CollectorServiceException("Empty parameter: remote_database");
        }
        if (StringUtils.isBlank((CharSequence)mdId)) {
            throw new CollectorServiceException("Empty parameter: remote_mdstore_id");
        }
        return () -> {
            try {
                return new RemoteMdStoreIterator(baseUrl, dbName, mdId);
            }
            catch (CollectorServiceException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

