/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.sftp.SftpIteratorFactory;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SftpCollectorPlugin
extends AbstractCollectorPlugin {
    private SftpIteratorFactory sftpIteratorFactory;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, final String fromDate, String toDate) throws CollectorServiceException {
        final String baseUrl = interfaceDescriptor.getBaseUrl();
        final String username = (String)interfaceDescriptor.getParams().get("username");
        final String authMethod = (String)interfaceDescriptor.getParams().get("authMethod");
        final String password = (String)interfaceDescriptor.getParams().get("password");
        final String privateKeyPath = (String)interfaceDescriptor.getParams().get("privateKeyPath");
        final String recursive = (String)interfaceDescriptor.getParams().get("recursive");
        final String extensions = (String)interfaceDescriptor.getParams().get("extensions");
        String portString = (String)interfaceDescriptor.getParams().get("port");
        int tmpPort = 22;
        if (StringUtils.isNotBlank((CharSequence)portString)) {
            try {
                tmpPort = Integer.parseInt((String)interfaceDescriptor.getParams().get("port"));
            }
            catch (NumberFormatException nfe) {
                throw new CollectorServiceException("Param 'port' must be an integer (or leave it blank for default 22)");
            }
        }
        final int port = tmpPort;
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new CollectorServiceException("Param 'baseurl' is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new CollectorServiceException("Param 'username' is null or empty");
        }
        if (StringUtils.isNotBlank((CharSequence)authMethod) && authMethod.equalsIgnoreCase("key")) {
            if (StringUtils.isBlank((CharSequence)privateKeyPath)) {
                throw new CollectorServiceException("Param 'privateKeyPath' is null or empty");
            }
        } else if (StringUtils.isBlank((CharSequence)password)) {
            throw new CollectorServiceException("Param 'password' is null or empty");
        }
        if (recursive == null || recursive.isEmpty()) {
            throw new CollectorServiceException("Param 'recursive' is null or empty");
        }
        if (extensions == null || extensions.isEmpty()) {
            throw new CollectorServiceException("Param 'extensions' is null or empty");
        }
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        return new Iterable<String>(){
            boolean isRecursive;
            Set<String> extensionsSet;
            {
                this.isRecursive = "true".equals(recursive);
                this.extensionsSet = this.parseSet(extensions);
            }

            @Override
            public Iterator<String> iterator() {
                return SftpCollectorPlugin.this.getSftpIteratorFactory().newIterator(authMethod, baseUrl, port, username, password, privateKeyPath, this.isRecursive, this.extensionsSet, fromDate);
            }

            private Set<String> parseSet(String extensions2) {
                return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)extensions2));
            }
        };
    }

    public SftpIteratorFactory getSftpIteratorFactory() {
        return this.sftpIteratorFactory;
    }

    public void setSftpIteratorFactory(SftpIteratorFactory sftpIteratorFactory) {
        this.sftpIteratorFactory = sftpIteratorFactory;
    }
}

