/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins;

import eu.dnetlib.data.collector.plugin.CollectorPluginErrorLogList;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpConnector {
    private static final Log log = LogFactory.getLog(HttpConnector.class);
    private int maxNumberOfRetry = 6;
    private int defaultDelay = 120;
    private int readTimeOut = 120;
    private String responseType = null;
    private String userAgent = "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)";
    public static final String HTTPHEADER_IETF_DRAFT_RATELIMIT_LIMIT = "X-RateLimit-Limit";
    public static final String HTTPHEADER_IETF_DRAFT_RATELIMIT_REMAINING = "X-RateLimit-Remaining";
    public static final String HTTPHEADER_IETF_DRAFT_RATELIMIT_RESET = "X-RateLimit-Reset";

    public HttpConnector() {
        CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
    }

    public String getInputSource(String requestUrl) throws CollectorServiceException {
        return this.attemptDownlaodAsString(requestUrl, 1, new CollectorPluginErrorLogList());
    }

    public InputStream getInputSourceAsStream(String requestUrl) throws CollectorServiceException {
        return this.attemptDownload(requestUrl, 1, new CollectorPluginErrorLogList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String attemptDownlaodAsString(String requestUrl, int retryNumber, CollectorPluginErrorLogList errorList) throws CollectorServiceException {
        String string;
        InputStream s = this.attemptDownload(requestUrl, 1, new CollectorPluginErrorLogList());
        try {
            string = IOUtils.toString((InputStream)s);
        }
        catch (IOException e) {
            String string2;
            try {
                log.error((Object)("error while retrieving from http-connection occured: " + requestUrl), (Throwable)e);
                Thread.sleep(this.defaultDelay * 1000);
                errorList.add((Object)e.getMessage());
                string2 = this.attemptDownlaodAsString(requestUrl, retryNumber + 1, errorList);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)s);
                    throw throwable;
                }
                catch (InterruptedException e2) {
                    throw new CollectorServiceException((Throwable)e2);
                }
            }
            IOUtils.closeQuietly((InputStream)s);
            return string2;
        }
        IOUtils.closeQuietly((InputStream)s);
        return string;
    }

    private InputStream attemptDownload(String requestUrl, int retryNumber, CollectorPluginErrorLogList errorList) throws CollectorServiceException {
        return this.attemptDownload(requestUrl, retryNumber, errorList, null);
    }

    private InputStream attemptDownload(String requestUrl, int retryNumber, CollectorPluginErrorLogList errorList, Map<String, String> requestHeader) throws CollectorServiceException {
        if (retryNumber > this.maxNumberOfRetry) {
            throw new CollectorServiceException("Max number of retries exceeded. Cause: \n " + errorList);
        }
        log.debug((Object)("Downloading " + requestUrl + " - try: " + retryNumber));
        try {
            InputStream input = null;
            if (requestUrl.startsWith("http")) {
                try {
                    HttpURLConnection urlConn = (HttpURLConnection)new URL(requestUrl).openConnection();
                    this.setRequestHeader(urlConn, requestHeader);
                    urlConn.setInstanceFollowRedirects(false);
                    urlConn.setReadTimeout(this.readTimeOut * 1000);
                    urlConn.addRequestProperty("User-Agent", this.userAgent);
                    if (log.isDebugEnabled()) {
                        this.logHeaderFields(urlConn);
                    }
                    int retryAfter = this.obtainRetryAfter(urlConn.getHeaderFields());
                    String rateLimit = urlConn.getHeaderField(HTTPHEADER_IETF_DRAFT_RATELIMIT_LIMIT);
                    String rateRemaining = urlConn.getHeaderField(HTTPHEADER_IETF_DRAFT_RATELIMIT_REMAINING);
                    if (rateLimit != null && rateRemaining != null && Integer.parseInt(rateRemaining) < 9) {
                        if (retryAfter > 0) {
                            this.backoffAndSleep(retryAfter);
                        } else {
                            this.backoffAndSleep(2000);
                        }
                    }
                    if (this.is2xx(urlConn.getResponseCode())) {
                        input = urlConn.getInputStream();
                        this.responseType = urlConn.getContentType();
                        return input;
                    }
                    if (this.is3xx(urlConn.getResponseCode())) {
                        String newUrl = this.obtainNewLocation(urlConn.getHeaderFields());
                        log.debug((Object)String.format("The requested url %s has been moved to %s", requestUrl, newUrl));
                        errorList.add((Object)String.format("%s %s %s. Moved to: %s", requestUrl, urlConn.getResponseCode(), urlConn.getResponseMessage(), newUrl));
                        urlConn.disconnect();
                        if (retryAfter > 0) {
                            Thread.sleep(retryAfter * 1000);
                        }
                        return this.attemptDownload(newUrl, retryNumber + 1, errorList, requestHeader);
                    }
                    if (this.is4xx(urlConn.getResponseCode())) {
                        errorList.add((Object)String.format("%s error %s: %s", requestUrl, urlConn.getResponseCode(), urlConn.getResponseMessage()));
                        throw new CollectorServiceException("4xx error: request will not be repeated. " + errorList);
                    }
                    if (this.is5xx(urlConn.getResponseCode())) {
                        switch (urlConn.getResponseCode()) {
                            case 503: {
                                if (retryAfter > 0) {
                                    log.warn((Object)(requestUrl + " - waiting and repeating request after suggested retry-after " + retryAfter + " sec."));
                                    Thread.sleep(retryAfter * 1000);
                                } else {
                                    log.warn((Object)(requestUrl + " - waiting and repeating request after default delay of " + this.defaultDelay + " sec."));
                                    Thread.sleep(this.defaultDelay * 1000);
                                }
                                errorList.add((Object)(requestUrl + " 503 Service Unavailable"));
                                urlConn.disconnect();
                                return this.attemptDownload(requestUrl, retryNumber + 1, errorList, requestHeader);
                            }
                        }
                        errorList.add((Object)String.format("%s Error %s: %s", requestUrl, urlConn.getResponseCode(), urlConn.getResponseMessage()));
                        throw new CollectorServiceException(urlConn.getResponseCode() + " error " + errorList);
                    }
                    throw new CollectorServiceException(String.format("Unexpected status code: %s error %s", urlConn.getResponseCode(), errorList));
                }
                catch (CollectorServiceException | MalformedURLException | NoRouteToHostException e) {
                    errorList.add((Object)String.format("Error: %s for request url: %s", e.getCause(), requestUrl));
                    throw new CollectorServiceException(e + "error " + errorList);
                }
                catch (IOException e) {
                    Thread.sleep(this.defaultDelay * 1000);
                    errorList.add((Object)(requestUrl + " " + e.getMessage()));
                    return this.attemptDownload(requestUrl, retryNumber + 1, errorList, requestHeader);
                }
            }
            if (requestUrl.startsWith("file")) {
                URL url = new URL(requestUrl);
                return url.openConnection().getInputStream();
            }
        }
        catch (IOException | InterruptedException e) {
            errorList.add((Object)String.format("Error: %s for request url: %s", e.getCause(), requestUrl));
            throw new CollectorServiceException(e + "error " + errorList);
        }
        throw new CollectorServiceException("Cannot support the download from " + requestUrl + " Only URLs that start with 'http' or 'file' are supported");
    }

    private void logHeaderFields(HttpURLConnection urlConn) throws IOException {
        log.debug((Object)("StatusCode: " + urlConn.getResponseMessage()));
        for (Map.Entry<String, List<String>> e : urlConn.getHeaderFields().entrySet()) {
            if (e.getKey() == null) continue;
            for (String v : e.getValue()) {
                log.debug((Object)("  key: " + e.getKey() + " - value: " + v));
            }
        }
    }

    private int obtainRetryAfter(Map<String, List<String>> headerMap) {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.toLowerCase().equals("retry-after") || headerMap.get(key).size() <= 0 || !NumberUtils.isCreatable((String)headerMap.get(key).get(0))) continue;
            return Integer.parseInt(headerMap.get(key).get(0)) + 10;
        }
        return -1;
    }

    private String obtainNewLocation(Map<String, List<String>> headerMap) throws CollectorServiceException {
        for (String key : headerMap.keySet()) {
            if (key == null || !key.toLowerCase().equals("location") || headerMap.get(key).size() <= 0) continue;
            return headerMap.get(key).get(0);
        }
        throw new CollectorServiceException("The requested url has been MOVED, but 'location' param is MISSING");
    }

    public void initTrustManager() {
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] xcs, String string) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{tm}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
        }
        catch (GeneralSecurityException e) {
            log.fatal((Object)e);
            throw new IllegalStateException(e);
        }
    }

    private boolean is2xx(int statusCode) {
        return statusCode >= 200 && statusCode <= 299;
    }

    private boolean is4xx(int statusCode) {
        return statusCode >= 400 && statusCode <= 499;
    }

    private boolean is3xx(int statusCode) {
        return statusCode >= 300 && statusCode <= 399;
    }

    private boolean is5xx(int statusCode) {
        return statusCode >= 500 && statusCode <= 599;
    }

    public int getMaxNumberOfRetry() {
        return this.maxNumberOfRetry;
    }

    public void setMaxNumberOfRetry(int maxNumberOfRetry) {
        this.maxNumberOfRetry = maxNumberOfRetry;
    }

    public int getDefaultDelay() {
        return this.defaultDelay;
    }

    public void setDefaultDelay(int defaultDelay) {
        this.defaultDelay = defaultDelay;
    }

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public String getResponseType() {
        return this.responseType;
    }

    private void setRequestHeader(HttpURLConnection conn, Map<String, String> requestHeader) {
        if (requestHeader != null) {
            for (String key : requestHeader.keySet()) {
                conn.setRequestProperty(key, requestHeader.get(key));
            }
            log.debug((Object)("Set Request Header with: " + requestHeader));
        }
    }

    private void backoffAndSleep(int sleepTimeMs) {
        try {
            Thread.sleep(sleepTimeMs);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

