/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.archive.targz;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import eu.dnetlib.data.collector.plugins.archive.targz.TarGzIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

public class TarGzIterable
implements Iterable<String> {
    private File tarGzFile;

    public TarGzIterable(InterfaceDescriptor interfaceDescriptor) throws CollectorServiceException {
        try {
            String tarGzPath = interfaceDescriptor.getBaseUrl();
            URL tarGzUrl = new URL(tarGzPath);
            this.tarGzFile = new File(tarGzUrl.getPath());
            if (!this.tarGzFile.exists()) {
                throw new CollectorServiceException(String.format("The base ULR %s, does not exist", this.tarGzFile.getPath()));
            }
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException("TarGz collector failed! ", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        TarGzIterator tgzIterator = new TarGzIterator(this.tarGzFile.getAbsolutePath());
        return Iterators.transform((Iterator)tgzIterator, (Function)new Function<String, String>(){

            public String apply(String inputRecord) {
                return XmlCleaner.cleanAllEntities(inputRecord.startsWith("\ufeff") ? inputRecord.substring(1) : inputRecord);
            }
        });
    }
}

