/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.httplist;

import eu.dnetlib.data.collector.plugins.HttpConnector;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;

public class HttpListIterator
implements Iterator<String> {
    private HttpConnector httpConnector;
    private String baseUrl;
    private String currentLine;
    private BufferedReader reader;

    public HttpListIterator(String baseUrl, String listAddress, HttpConnector httpConnector) {
        try {
            this.baseUrl = baseUrl;
            this.httpConnector = httpConnector;
            this.reader = new BufferedReader(new StringReader(this.download(listAddress)));
            this.currentLine = this.reader.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating iterator", e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return StringUtils.isNotBlank((CharSequence)this.currentLine);
    }

    @Override
    public synchronized String next() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.currentLine)) {
                String string = this.download(this.baseUrl + this.currentLine);
                return string;
            }
            throw new RuntimeException("Iterator has reached the end");
        }
        finally {
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException("Error obtaining next element " + this.currentLine, e);
            }
        }
    }

    private String download(String url) {
        try {
            return this.httpConnector.getInputSource(url);
        }
        catch (CollectorServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
    }
}

