/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SftpIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(SftpIterator.class);
    private static final int MAX_RETRIES = 5;
    private static final int DEFAULT_TIMEOUT = 30000;
    private static final long BACKOFF_MILLIS = 10000L;
    private AUTHMETHOD authenticationMethod;
    private String baseUrl;
    private String sftpURIScheme;
    private String sftpServerAddress;
    private String remoteSftpBasePath;
    private int port;
    private String username;
    private String password;
    private String privateKeyPath;
    private boolean isRecursive;
    private Set<String> extensionsSet;
    private boolean incremental;
    private Session sftpSession;
    private ChannelSftp sftpChannel;
    private Queue<String> queue;
    private DateTime fromDate = null;
    private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static String EMPTY_RECORD = "<record/>";

    public SftpIterator(String authenticationMethod, String baseUrl, int port, String username, String password, String privateKeyPath, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.baseUrl = baseUrl;
        this.port = port;
        this.username = username;
        this.password = password;
        this.privateKeyPath = privateKeyPath;
        this.authenticationMethod = AUTHMETHOD.LOGIN;
        if (StringUtils.isNotBlank((CharSequence)authenticationMethod) && authenticationMethod.equalsIgnoreCase("key")) {
            this.authenticationMethod = AUTHMETHOD.KEY;
        }
        this.isRecursive = isRecursive;
        this.extensionsSet = extensionsSet;
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = DateTime.parse((String)fromDate, (DateTimeFormatter)this.simpleDateTimeFormatter);
            log.debug((Object)("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString()));
        }
        try {
            URI sftpServer = new URI(baseUrl);
            this.sftpURIScheme = sftpServer.getScheme();
            this.sftpServerAddress = sftpServer.getHost();
            this.remoteSftpBasePath = sftpServer.getPath();
        }
        catch (URISyntaxException e) {
            throw new CollectorServiceRuntimeException("Bad syntax in the URL " + baseUrl);
        }
        this.connectToSftpServer();
        this.initializeQueue();
    }

    private void connectToSftpServer() {
        JSch jsch = new JSch();
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            switch (this.authenticationMethod) {
                case KEY: {
                    log.debug((Object)"Authenticating with private key");
                    jsch.addIdentity(this.privateKeyPath);
                    this.sftpSession = jsch.getSession(this.username, this.sftpServerAddress, this.port);
                    break;
                }
                default: {
                    log.debug((Object)"Authenticating with password");
                    this.sftpSession = jsch.getSession(this.username, this.sftpServerAddress, this.port);
                    this.sftpSession.setPassword(this.password);
                }
            }
            this.sftpSession.connect();
            log.debug((Object)"SFTP session connected");
            Channel channel = this.sftpSession.openChannel(this.sftpURIScheme);
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
            String pwd = this.sftpChannel.pwd();
            log.debug((Object)("PWD from server: " + pwd));
            String fullPath = pwd + this.remoteSftpBasePath;
            this.sftpChannel.cd(fullPath);
            log.debug((Object)("PWD from server 2 after 'cd " + fullPath + "' : " + this.sftpChannel.pwd()));
            log.info((Object)("Connected to SFTP server " + this.sftpServerAddress));
        }
        catch (JSchException e) {
            throw new CollectorServiceRuntimeException("Unable to connect to remote SFTP server.", (Throwable)e);
        }
        catch (SftpException e) {
            throw new CollectorServiceRuntimeException("Unable to access the base remote path on the SFTP server.", (Throwable)e);
        }
    }

    protected void disconnectFromSftpServer() {
        this.sftpChannel.exit();
        this.sftpSession.disconnect();
    }

    private void initializeQueue() {
        this.queue = new LinkedList<String>();
        log.info((Object)String.format("SFTP collector plugin collecting from %s with recursion = %s, incremental = %s with fromDate=%s", this.remoteSftpBasePath, this.isRecursive, this.incremental, this.fromDate));
        this.listDirectoryRecursive(".", "");
    }

    private void listDirectoryRecursive(String parentDir, String currentDir) {
        String dirToList = parentDir;
        if (StringUtils.isNotBlank((CharSequence)currentDir)) {
            dirToList = dirToList + "/" + currentDir;
        }
        log.debug((Object)("PARENT DIR: " + parentDir));
        log.debug((Object)("DIR TO LIST: " + dirToList));
        try {
            Vector ls = this.sftpChannel.ls(dirToList);
            for (ChannelSftp.LsEntry entry : ls) {
                String currentFileName = entry.getFilename();
                if (currentFileName.equals(".") || currentFileName.equals("..")) continue;
                SftpATTRS attrs = entry.getAttrs();
                if (attrs.isDir()) {
                    if (!this.isRecursive) continue;
                    this.listDirectoryRecursive(dirToList, currentFileName);
                    continue;
                }
                for (String ext : this.extensionsSet) {
                    if (!currentFileName.endsWith(ext)) continue;
                    if (dirToList.length() > 2) {
                        currentFileName = dirToList + "/" + currentFileName;
                    }
                    if (this.incremental) {
                        int mTime = attrs.getMTime();
                        DateTime dt = new DateTime((long)mTime * 1000L);
                        if (dt.isAfter((ReadableInstant)this.fromDate)) {
                            this.queue.add(currentFileName);
                            log.debug((Object)(currentFileName + " has changed and must be re-collected"));
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)(currentFileName + " has not changed since last collection"));
                        continue;
                    }
                    this.queue.add(currentFileName);
                }
            }
        }
        catch (SftpException e) {
            throw new CollectorServiceRuntimeException("Cannot list the sftp remote directory", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            this.disconnectFromSftpServer();
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        String nextRemotePath = this.queue.remove();
        int nRepeat = 0;
        String fullPathFile = nextRemotePath;
        while (nRepeat < 5) {
            try {
                String doc;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.sftpChannel.get(nextRemotePath, (OutputStream)baos);
                if (log.isDebugEnabled()) {
                    fullPathFile = this.sftpChannel.pwd() + "/" + nextRemotePath;
                    log.debug((Object)String.format("Collected file from SFTP: %s%s", this.sftpServerAddress, fullPathFile));
                }
                if (StringUtils.isNotBlank((CharSequence)(doc = baos.toString()))) {
                    return doc;
                }
                return EMPTY_RECORD;
            }
            catch (SftpException e) {
                log.warn((Object)String.format("An error occurred [%s] for %s%s, retrying.. [retried %s time(s)]", e.getMessage(), this.sftpServerAddress, fullPathFile, ++nRepeat));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error((Object)e1);
                }
            }
        }
        throw new CollectorServiceRuntimeException(String.format("Impossible to retrieve FTP file %s after %s retries. Aborting FTP collection.", fullPathFile, nRepeat));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum AUTHMETHOD {
        LOGIN,
        KEY;

    }
}

