/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.mdstore.model;

import java.util.List;
import java.util.Map;

public class MDStoreInfo {
    private static String DEFAULT_XQUERY_DELIMITER = "@::@";
    private String id;
    private String serviceURI;
    private String format;
    private String layout;
    private String interpretation;
    private String lastStorageDate;
    private Map<String, String> datasourcesInvolved;
    private List<String> indexFields;
    private int size;

    public static MDStoreInfo fromXqueryResult(String result) {
        MDStoreInfo info = new MDStoreInfo();
        String[] values = result.split(DEFAULT_XQUERY_DELIMITER);
        if (values == null || values.length != 5) {
            return null;
        }
        info.setServiceURI(values[0]);
        info.setId(values[1]);
        String[] mdFormat = values[2].split("\\(-\\)");
        if (mdFormat == null || mdFormat.length != 3) {
            return null;
        }
        info.setFormat(mdFormat[0]);
        info.setLayout(mdFormat[1]);
        info.setInterpretation(mdFormat[2]);
        info.setLastStorageDate(values[3]);
        info.setSize(new Integer(values[4]));
        return info;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getServiceURI() {
        return this.serviceURI;
    }

    public void setServiceURI(String serviceURI) {
        this.serviceURI = serviceURI;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getLastStorageDate() {
        return this.lastStorageDate;
    }

    public void setLastStorageDate(String lastStorageDate) {
        this.lastStorageDate = lastStorageDate;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Map<String, String> getDatasourcesInvolved() {
        return this.datasourcesInvolved;
    }

    public void setDatasourcesInvolved(Map<String, String> datasourcesInvolved) {
        this.datasourcesInvolved = datasourcesInvolved;
    }

    public List<String> getIndexFields() {
        return this.indexFields;
    }

    public void setIndexFields(List<String> indexFields) {
        this.indexFields = indexFields;
    }
}

