/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.mdstore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.modular.MDFormatDescription;
import eu.dnetlib.data.mdstore.modular.MDStoreUtils;
import eu.dnetlib.data.mdstore.modular.ModularMDStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.functionality.modular.ui.mdstore.MDStoreUIException;
import eu.dnetlib.functionality.modular.ui.mdstore.model.MDStoreInfo;
import eu.dnetlib.functionality.modular.ui.mdstore.model.MDStoreResult;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MDStoreServiceInternalController {
    private static final Log log = LogFactory.getLog(MDStoreServiceInternalController.class);
    @Value(value="${dnet.modular.ui.mdstore.xslt.record2document}")
    private String recordXsltClasspath;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private MDStoreUtils mdStoreUtils;
    @Resource
    private ResultSetClientFactory resultSetClientFactory;
    @Autowired
    private ModularMDStoreService mdStoreService;
    private Map<String, Info> datasourceCache;

    @RequestMapping(value={"/ui/mdstore/listMDStores.do"})
    @ResponseBody
    public List<MDStoreInfo> listMDStores(ModelMap map) throws Exception {
        if (this.datasourceCache == null) {
            this.datasourceCache = this.datasourceFromMdStore();
        }
        String xquery = "for $x in  collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')  let $format := $x//METADATA_FORMAT  let $layout := $x//METADATA_FORMAT_LAYOUT  let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $uri := $x//RESOURCE_URI/@value/string()  let $id := $x//RESOURCE_IDENTIFIER/@value/string() let $lastDate := $x//LAST_STORAGE_DATE  let $size :=$x//NUMBER_OF_RECORDS return concat($uri,'@::@',$id,'@::@',$format,'(-)',$layout, '(-)',$interpretation,'@::@',$lastDate,'@::@',$size) ";
        log.debug((Object)"Executing lookup queryfor $x in  collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')  let $format := $x//METADATA_FORMAT  let $layout := $x//METADATA_FORMAT_LAYOUT  let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $uri := $x//RESOURCE_URI/@value/string()  let $id := $x//RESOURCE_IDENTIFIER/@value/string() let $lastDate := $x//LAST_STORAGE_DATE  let $size :=$x//NUMBER_OF_RECORDS return concat($uri,'@::@',$id,'@::@',$format,'(-)',$layout, '(-)',$interpretation,'@::@',$lastDate,'@::@',$size) ");
        return Lists.transform((List)((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in  collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')  let $format := $x//METADATA_FORMAT  let $layout := $x//METADATA_FORMAT_LAYOUT  let $interpretation :=$x//METADATA_FORMAT_INTERPRETATION let $uri := $x//RESOURCE_URI/@value/string()  let $id := $x//RESOURCE_IDENTIFIER/@value/string() let $lastDate := $x//LAST_STORAGE_DATE  let $size :=$x//NUMBER_OF_RECORDS return concat($uri,'@::@',$id,'@::@',$format,'(-)',$layout, '(-)',$interpretation,'@::@',$lastDate,'@::@',$size) "), input -> {
            MDStoreInfo mdStoreInfo = MDStoreInfo.fromXqueryResult(input);
            Info currentInfo = this.datasourceCache.get(mdStoreInfo.getId());
            if (currentInfo != null) {
                HashMap datasourcesInvolved = mdStoreInfo.getDatasourcesInvolved();
                if (datasourcesInvolved == null) {
                    datasourcesInvolved = Maps.newHashMap();
                    mdStoreInfo.setDatasourcesInvolved(datasourcesInvolved);
                }
                datasourcesInvolved.put("datasourceId", currentInfo.getDatasourceId());
                datasourcesInvolved.put("datasourceName", currentInfo.getDatasourceName());
            }
            return mdStoreInfo;
        });
    }

    @RequestMapping(value={"/ui/mdstore/reloadInfo"})
    @ResponseBody
    public List<MDStoreInfo> reloadInfo(ModelMap map) throws Exception {
        this.datasourceCache = null;
        return this.listMDStores(map);
    }

    @RequestMapping(value={"/ui/mdstore/getMdStoreInfo.do"})
    @ResponseBody
    public MDStoreInfo getMdStoreInfo(ModelMap map, @RequestParam(value="id", required=true) String profileId) throws Exception {
        MDStoreInfo mdStoreInfo = this.retrieveMDStoreInfo(profileId);
        List indexFields = this.mdStoreUtils.getField(mdStoreInfo.getFormat(), mdStoreInfo.getLayout());
        if (indexFields != null) {
            List<String> idFields = indexFields.stream().map(MDFormatDescription::getName).collect(Collectors.toList());
            mdStoreInfo.setIndexFields(idFields);
        }
        return mdStoreInfo;
    }

    @RequestMapping(value={"/ui/mdstore/findRecords"}, method={RequestMethod.POST})
    @ResponseBody
    public MDStoreResult findRecords(ModelMap map, @RequestBody Map<String, String> queryParam) throws Exception {
        if (!queryParam.containsKey("mdId")) {
            throw new MDStoreUIException("mdId parameters expected");
        }
        String mdId = queryParam.get("mdId");
        int offset = 0;
        if (queryParam.containsKey("page")) {
            try {
                offset = Integer.parseInt(queryParam.get("page"));
                queryParam.remove("page");
            }
            catch (Exception e) {
                log.error((Object)("Error on parsing page " + queryParam.get("page")));
            }
        }
        queryParam.remove("mdId");
        MDStoreResult res = new MDStoreResult();
        ClassPathResource cpr = new ClassPathResource(this.recordXsltClasspath);
        ApplyXslt xslt = new ApplyXslt((org.springframework.core.io.Resource)cpr);
        res.setResult(this.mdStoreService.getMDStoreRecords(mdId, 10, offset, queryParam).stream().map(arg_0 -> ((ApplyXslt)xslt).evaluate(arg_0)).collect(Collectors.toList()));
        int count = 0;
        try {
            count = Integer.parseInt(queryParam.get("count"));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        res.setCount(count);
        return res;
    }

    @RequestMapping(value={"/ui/mdstore/mdStoreResults"})
    @ResponseBody
    public MDStoreResult getMDStoreResults(ModelMap map, @RequestParam(value="mdId", required=true) String mdId, @RequestParam(value="from", required=true) int from, @RequestParam(value="id_query", required=false) String idToQuery, @RequestParam(value="free_query", required=false) String freeQuery) throws Exception {
        MDStoreService mdService = (MDStoreService)this.serviceLocator.getService(MDStoreService.class, mdId);
        ClassPathResource cpr = new ClassPathResource(this.recordXsltClasspath);
        ApplyXslt xslt = new ApplyXslt((org.springframework.core.io.Resource)cpr);
        MDStoreResult resultValues = new MDStoreResult();
        resultValues.setCount(this.getMdStoreInfo(map, mdId).getSize());
        if (idToQuery != null && !idToQuery.isEmpty()) {
            try {
                String record = mdService.deliverRecord(mdId, idToQuery);
                resultValues.setResult(Lists.newArrayList((Object[])new String[]{xslt.evaluate((Object)record)}));
                return resultValues;
            }
            catch (DocumentNotFoundException e) {
                return null;
            }
        }
        W3CEndpointReference epr = mdService.deliverMDRecords(mdId, null, null, null);
        IterableResultSetClient result = this.resultSetClientFactory.getClient(epr);
        ArrayList<String> convertedList = new ArrayList<String>();
        Iterator it = result.iterator();
        for (int currentCounter = 0; currentCounter < from; ++currentCounter) {
            if (it.hasNext()) {
                it.next();
                continue;
            }
            resultValues.setResult(convertedList);
            return resultValues;
        }
        for (int i = 0; i < 10 && it.hasNext(); ++i) {
            convertedList.add(xslt.evaluate(it.next()));
        }
        resultValues.setResult(convertedList);
        return resultValues;
    }

    private Map<String, Info> datasourceFromMdStore() {
        String query = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x[.//PARAM/@category/string()='MDSTORE_ID'] return concat($x//PARAM[./@name='providerId'][1]/string(), '<::>',$x//PARAM[./@name='providerName'][1]/string(), '<::>', string-join($x//PARAM[./@category/string()='MDSTORE_ID']/string(), '--'))";
        ISLookUpService lookupService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        try {
            HashMap result = Maps.newHashMap();
            List results = lookupService.quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x[.//PARAM/@category/string()='MDSTORE_ID'] return concat($x//PARAM[./@name='providerId'][1]/string(), '<::>',$x//PARAM[./@name='providerName'][1]/string(), '<::>', string-join($x//PARAM[./@category/string()='MDSTORE_ID']/string(), '--'))");
            for (String item : results) {
                String[] splitted = item.split("<::>");
                if (splitted == null || splitted.length != 3) continue;
                Info currentInfo = new Info();
                currentInfo.setDatasourceId(splitted[0]);
                currentInfo.setDatasourceName(splitted[1]);
                String[] mdstores = splitted[2].split("--");
                if (mdstores == null) continue;
                for (String mdstore : mdstores) {
                    result.put(mdstore, currentInfo);
                }
            }
            return result;
        }
        catch (ISLookUpException e) {
            log.error((Object)e);
            return null;
        }
    }

    private MDStoreInfo retrieveMDStoreInfo(String identifier) {
        MDStoreInfo result = null;
        try {
            result = null;
            String xquery = " for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')  where $x//RESOURCE_IDENTIFIER/@value/string()=\"%s\"   return concat($x//RESOURCE_URI/@value/string() , '@::@',$x//RESOURCE_IDENTIFIER/@value/string() ,'@::@',$x//METADATA_FORMAT,'(-)',$x//METADATA_FORMAT_LAYOUT,   '(-)', $x//METADATA_FORMAT_INTERPRETATION ,'@::@',$x//LAST_STORAGE_DATE,'@::@',$x//NUMBER_OF_RECORDS)";
            List results = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(String.format(" for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType')  where $x//RESOURCE_IDENTIFIER/@value/string()=\"%s\"   return concat($x//RESOURCE_URI/@value/string() , '@::@',$x//RESOURCE_IDENTIFIER/@value/string() ,'@::@',$x//METADATA_FORMAT,'(-)',$x//METADATA_FORMAT_LAYOUT,   '(-)', $x//METADATA_FORMAT_INTERPRETATION ,'@::@',$x//LAST_STORAGE_DATE,'@::@',$x//NUMBER_OF_RECORDS)", identifier));
            if (results != null && !results.isEmpty()) {
                result = MDStoreInfo.fromXqueryResult((String)results.get(0));
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)String.format("Error on getting information for mdstore with identifier: %s", identifier), (Throwable)e);
        }
        return result;
    }

    private Map<String, String> findDatasourceNameAssociatedToMdStore(String mdStoreId) throws ISLookUpException {
        String baseQuery = "for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x[.//PARAM/string()='%s'] return concat($x//PARAM[./@name='providerId'][1]/string(), '<::>',$x//PARAM[./@name='providerName'][1]/string())";
        ISLookUpService lookupService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        List result = lookupService.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x[.//PARAM/string()='%s'] return concat($x//PARAM[./@name='providerId'][1]/string(), '<::>',$x//PARAM[./@name='providerName'][1]/string())", mdStoreId));
        HashMap datasources = Maps.newHashMap();
        for (String item : result) {
            String[] splitted = item.split("<::>");
            if (splitted == null || splitted.length != 2) continue;
            datasources.put(splitted[0], splitted[1]);
        }
        return datasources;
    }

    class Info {
        private String datasourceId;
        private String datasourceName;
        private String mdStoreId;

        Info() {
        }

        public String getDatasourceName() {
            return this.datasourceName;
        }

        public void setDatasourceName(String datasourceName) {
            this.datasourceName = datasourceName;
        }

        public String getDatasourceId() {
            return this.datasourceId;
        }

        public void setDatasourceId(String datasourceId) {
            this.datasourceId = datasourceId;
        }

        public String getMdStoreId() {
            return this.mdStoreId;
        }

        public void setMdStoreId(String mdStoreId) {
            this.mdStoreId = mdStoreId;
        }
    }
}

