/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.repositories;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.ProtocolParameterValue;
import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParamImpl;
import eu.dnetlib.enabling.datasources.common.BrowsableField;
import eu.dnetlib.enabling.datasources.common.BrowseTerm;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.PidSystem;
import eu.dnetlib.enabling.datasources.common.SearchApisEntry;
import eu.dnetlib.enabling.datasources.common.SimpleDatasource;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.repositories.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoInterfaceEntry;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.msro.workflows.sarasvati.loader.WorkflowExecutor;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@Controller
public class RepoInternalController
extends AbstractAjaxController {
    @Autowired
    private LocalOpenaireDatasourceManager dsManager;
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Resource
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Resource
    private WorkflowExecutor workflowExecutor;
    @Resource
    private RepoUIUtils repoUIUtils;
    @Value(value="${repo.ui.mdstore.sync.button}")
    private String syncButton;
    @Value(value="${repo.ui.mdstore.sync.remote.desc}")
    private String syncDesc;
    @Value(value="${repo.ui.mdstore.sync.remote.api.baseUrl}")
    private String syncApiBaseUrl;
    @Value(value="${repo.ui.mdstore.sync.remote.is.baseUrl}")
    private String syncISBaseUrl;
    @Value(value="${repo.ui.mdstore.sync.local.mongodb.url}")
    private String mongoUrl;
    @Value(value="${services.mdstore.mongodb.db}")
    private String mongoDb;
    private static final Log log = LogFactory.getLog(RepoInternalController.class);

    @RequestMapping(value={"/ui/browseRepoField.do"})
    @ResponseBody
    public List<? extends BrowseTerm> browseRepoField(@RequestParam(value="field", required=true) String field) throws Exception {
        return this.dsManager.browseField(field);
    }

    @Cacheable(cacheNames={"repoUIJsonCache"}, key="#param, #value", condition="#refresh == false")
    @RequestMapping(value={"/ui/listApis.do"})
    @ResponseBody
    public List<? extends SearchApisEntry> listApis(@RequestParam(value="param", required=true) String param, @RequestParam(value="value", required=true) String value, @RequestParam(value="refresh", required=false) String refresh) throws Exception {
        return this.dsManager.searchApis(param, (Object)value);
    }

    @RequestMapping(value={"/ui/listRepositories.json"})
    @ResponseBody
    public List<SimpleDatasource> listRepositories(@RequestParam(value="type", required=true) String type) throws Exception {
        return this.dsManager.searchDatasourcesByType(type);
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/validateRepo.do"})
    @ResponseBody
    public String listRepositories(@RequestParam(value="id", required=true) String id, @RequestParam(value="b", required=true) boolean b) throws Exception {
        String query = "count(/*[.//RESOURCE_TYPE/@value='MetaWorkflowDSResourceType' and .//DATAPROVIDER/@id='" + id + "'])";
        if (!b && Integer.parseInt(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query)) > 0) {
            throw new Exception("Repo " + id + " can be invalidated: it is related to some metawfs");
        }
        String newId = b ? ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).validateProfile(id) : ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).invalidateProfile(id);
        return newId;
    }

    @RequestMapping(value={"/ui/getRepoDetails.do"})
    public void getRepoDetails(HttpServletResponse response, @RequestParam(value="id", required=true) String id) throws Exception {
        Datasource ds = this.dsManager.getDs(id);
        List apis = this.dsManager.getApis(id);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        JsonNode jsonDs = mapper.valueToTree((Object)ds);
        ((ObjectNode)jsonDs).put("apis", mapper.valueToTree((Object)apis));
        response.setContentType("application/json;charset=UTF-8");
        IOUtils.write((String)jsonDs.toString(), (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/repoMetaWf.new"})
    @ResponseBody
    public String newDataProviderWorkflow(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="name", required=true) String repoName, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="wf", required=true) String wfId) throws Exception {
        HashMap params = Maps.newHashMap();
        params.put("dataprovider:id", repoId);
        params.put("dataprovider:name", repoName);
        params.put("dataprovider:interface", ifaceId);
        return this.workflowExecutor.startProcess(wfId, (Map)params);
    }

    @RequestMapping(value={"/ui/repoMetaWf.destroy"})
    @ResponseBody
    public String destroyDataProviderWorkflow(@RequestParam(value="destroyWf", required=true) String destroyWfId) throws Exception {
        return this.workflowExecutor.startProcess(destroyWfId, null);
    }

    @RequestMapping(value={"/ui/repoApi.get"})
    @ResponseBody
    public RepoInterfaceEntry getRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="ifaceId", required=true) String ifaceId) throws Exception {
        return this.repoUIUtils.getApi(repoId, ifaceId);
    }

    @RequestMapping(value={"/ui/repoApi.update"})
    @ResponseBody
    public boolean updateRepoApi(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="accessParams", required=false) String accessParamsJson, @RequestParam(value="mdIdPath", required=false) String mdIdPath) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)accessParamsJson)) {
            Map params = (Map)new Gson().fromJson(accessParamsJson, new TypeToken<Map<String, String>>(){}.getType());
            String baseUrl = (String)params.remove("baseUrl");
            this.dsManager.updateApiDetails(repoId, ifaceId, mdIdPath, baseUrl, params);
        }
        return true;
    }

    @RequestMapping(value={"/ui/repoApi.delete"})
    @ResponseBody
    public boolean deleteRepoApi(@RequestParam(value="repo", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        this.dsManager.deleteApi(repoId, ifaceId);
        return true;
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/repoApiCompliance.update"})
    @ResponseBody
    public boolean updateRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="compliance", required=true) String compliance) throws Exception {
        log.debug((Object)("SET COMPLIANCE TO " + compliance));
        this.dsManager.updateCompliance(repoId, ifaceId, compliance, true);
        return true;
    }

    @CacheEvict(value={"repoUIJsonCache"})
    @RequestMapping(value={"/ui/repoApiCompliance.reset"})
    @ResponseBody
    public boolean resetRepoApiCompliance(@RequestParam(value="id", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        log.debug((Object)"RESET COMPLIANCE");
        this.dsManager.updateCompliance(repoId, ifaceId, null, true);
        return true;
    }

    @RequestMapping(value={"/ui/repos/repoApi.html"})
    public void repoApiHtml(ModelMap map) throws Exception {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.syncButton, this.syncDesc, this.syncApiBaseUrl, this.syncISBaseUrl})) {
            map.addAttribute("syncButton", (Object)this.syncButton);
            map.addAttribute("syncDesc", (Object)this.syncDesc);
            map.addAttribute("syncISBaseUrl", (Object)this.syncISBaseUrl);
            map.addAttribute("mongoDB", (Object)this.mongoDb);
            map.addAttribute("mongoUrl", (Object)this.mongoUrl);
        }
    }

    @RequestMapping(value={"/ui/repoApi.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceJson) throws DsmException {
        Api iface = (Api)new Gson().fromJson(ifaceJson, new TypeToken<Api<ApiParamImpl>>(){}.getType());
        iface.setDatasource(repoId);
        log.info((Object)("Adding api " + iface.getId() + " to repository " + repoId));
        this.dsManager.addApi(iface);
        return true;
    }

    @RequestMapping(value={"/ui/repo.new"})
    @ResponseBody
    public boolean addRepoApi(@RequestParam(value="repo", required=true) String repoJson) throws DsmException {
        Datasource ds = (Datasource)new Gson().fromJson(repoJson, new TypeToken<Datasource<Organization<?>, Identity, PidSystem>>(){}.getType());
        java.util.Date now = new java.util.Date();
        ds.setDateofcollection(new Date(now.getTime()));
        if (StringUtils.isBlank((CharSequence)ds.getEnglishname())) {
            ds.setEnglishname(ds.getOfficialname());
        }
        if (StringUtils.isBlank((CharSequence)ds.getProvenanceaction())) {
            ds.setProvenanceaction("user:insert");
        }
        log.info((Object)("Adding datasource " + ds.getId() + " - name " + ds.getOfficialname()));
        this.dsManager.saveDs(ds);
        return true;
    }

    @RequestMapping(value={"/ui/listValidValuesForParam.do"})
    @ResponseBody
    public List<ProtocolParameterValue> listValidValuesForParam(@RequestParam(value="protocol", required=true) String protocol, @RequestParam(value="param", required=true) String param, @RequestParam(value="baseUrl", required=true) String baseUrl) throws CollectorServiceException {
        return ((CollectorService)this.serviceLocator.getService(CollectorService.class)).listValidValuesForParam(protocol, baseUrl, param, null);
    }

    @RequestMapping(value={"/ui/remoteDatasource/apis"}, method={RequestMethod.GET})
    public void listRemoteApis(@RequestParam(value="repo", required=true) String repoId, HttpServletResponse response) throws IOException {
        RestTemplate restTemplate = new RestTemplate();
        String res = (String)restTemplate.getForObject(this.syncApiBaseUrl + "/ds/api/" + repoId, String.class, new Object[0]);
        response.setContentType("application/json;charset=UTF-8");
        IOUtils.write((String)res, (OutputStream)response.getOutputStream());
    }

    @RequestMapping(value={"/ui/remoteDatasource/api"}, method={RequestMethod.POST})
    public void saveRemoteApi(@RequestBody Api<ApiParamImpl> api, HttpServletResponse response) throws IOException {
        String url = this.syncApiBaseUrl + "/ds/api/add";
        log.info((Object)"Adding new remote API:");
        log.info((Object)(" - repo id: " + api.getDatasource()));
        log.info((Object)(" - api id: " + api.getId()));
        log.info((Object)(" - rest call: " + url));
        log.info((Object)(" - json: " + new Gson().toJson(api)));
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.postForObject(url, api, Void.class, new Object[0]);
        this.listRemoteApis(api.getDatasource(), response);
    }

    @ResponseBody
    @RequestMapping(value={"/ui/updateRepoTickets.do"}, method={RequestMethod.POST})
    public List<BrowsableField> updateRepoTickets(@RequestParam(name="id", required=true) String repoId, @RequestBody List<Integer> tickets) throws Exception {
        return this.repoUIUtils.updateTicketsForDatasource(repoId, new LinkedHashSet<Integer>(tickets));
    }
}

