/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.sarasvati.icons;

import com.googlecode.sarasvati.JoinType;
import com.googlecode.sarasvati.Node;
import com.googlecode.sarasvati.visual.icon.AbstractNodeIcon;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public abstract class AbstractIcon
extends AbstractNodeIcon {
    protected static final int ROUND_CORNER = 10;
    protected static final int DASH_EMPTY = 4;
    protected static final int DASH_FULL = 8;
    protected static final int FONT_SIZE = 10;
    private Node node;
    private boolean join;
    private String label;
    private Color color;
    private float[] dashes;
    private boolean terminal;
    private boolean failed;

    public AbstractIcon(Node node) {
        this.node = node;
        this.label = (String)node.getAdaptor(String.class);
        if (this.label == null) {
            this.label = node.getName();
        }
        this.join = node.getJoinType() == null ? false : node.getJoinType() != JoinType.OR;
        this.color = Color.lightGray;
        if (this.join) {
            this.dashes = new float[]{8.0f, 4.0f};
        }
        this.terminal = node.getGraph().getOutputArcs(node).size() == 0;
    }

    public void resetGfx(Graphics2D gfx) {
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.setFont(Font.getFont("Monospaced"));
        if (this.isTerminal()) {
            gfx.setFont(gfx.getFont().deriveFont(1));
        }
        gfx.setColor(this.color);
    }

    public boolean isJoin() {
        return this.join;
    }

    public void setJoin(boolean join) {
        this.join = join;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float[] getDashes() {
        return this.dashes;
    }

    public void setDashes(float[] dashes) {
        this.dashes = dashes;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public boolean isTerminal() {
        return this.terminal;
    }

    public void setTerminal(boolean terminal) {
        this.terminal = terminal;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }
}

