/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.collector.rmi.CollectorService;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DateRangeCollectRecordsJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?, ?>, Api<ApiParam>> dsManager;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;
    private String fromDateParam;
    private String untilDateParam;
    private String overrideFrom;
    private String overrideUntil;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String fromDate = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.overrideFrom}) ? this.overrideFrom : token.getEnv().getAttribute(this.getFromDateParam());
        String untilDate = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.overrideUntil}) ? this.overrideUntil : token.getEnv().getAttribute(this.getUntilDateParam());
        Api api = this.dsManager.getApis(this.datasourceId).stream().filter(a -> a.getId().equals(this.datasourceInterface)).findFirst().orElseThrow(() -> new MSROException("Api not found"));
        InterfaceDescriptor interfaceDescriptor = new InterfaceDescriptor();
        interfaceDescriptor.setBaseUrl(api.getBaseurl());
        interfaceDescriptor.setId(this.datasourceInterface);
        interfaceDescriptor.setProtocol(api.getProtocol());
        api.getApiParams().forEach(p -> interfaceDescriptor.getParams().put(p.getParam(), p.getValue()));
        W3CEndpointReference epr = ((CollectorService)this.serviceLocator.getService(CollectorService.class)).dateRangeCollect(interfaceDescriptor, fromDate, untilDate);
        token.getEnv().setAttribute(this.getEprParam(), epr.toString());
        token.getEnv().setAttribute("dataprovider:interface:baseUrl", interfaceDescriptor.getBaseUrl());
        token.getEnv().setAttribute("dataprovider:protocol", interfaceDescriptor.getProtocol());
        HashMap params = interfaceDescriptor.getParams();
        if (params != null) {
            for (Map.Entry e : params.entrySet()) {
                token.getEnv().setAttribute("dataprovider:" + (String)e.getKey(), (String)e.getValue());
            }
        }
        return Arc.DEFAULT_ARC;
    }

    public String getFromDateParam() {
        return this.fromDateParam;
    }

    public void setFromDateParam(String fromDateParam) {
        this.fromDateParam = fromDateParam;
    }

    public String getUntilDateParam() {
        return this.untilDateParam;
    }

    public void setUntilDateParam(String untilDateParam) {
        this.untilDateParam = untilDateParam;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getOverrideFrom() {
        return this.overrideFrom;
    }

    public void setOverrideFrom(String overrideFrom) {
        this.overrideFrom = overrideFrom;
    }

    public String getOverrideUntil() {
        return this.overrideUntil;
    }

    public void setOverrideUntil(String overrideUntil) {
        this.overrideUntil = overrideUntil;
    }
}

