/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.XSLTMappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class MdBuilderJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(MdBuilderJobNode.class);
    private Resource mdBuilderTemplateXslt;
    private String inputEprParam;
    private String outputEprParam;
    private String datasourceId;
    private String datasourceInterface;
    private XSLTMappedResultSetFactory xsltMappedResultSetFactory;
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(NodeToken token) throws MSROException {
        String inputEpr = token.getEnv().getAttribute(this.inputEprParam);
        if (inputEpr == null || inputEpr.isEmpty()) {
            throw new MSROException("InputEprParam (" + this.inputEprParam + ") not found in ENV");
        }
        StringTemplate st = null;
        try {
            Datasource ds = this.dsManager.getDs(this.datasourceId);
            Api api = this.dsManager.getApis(this.datasourceId).stream().filter(a -> a.getId().equals(this.datasourceInterface)).findFirst().orElseThrow(() -> new Exception("Api not found"));
            st = new StringTemplate(IOUtils.toString((InputStream)this.getMdBuilderTemplateXslt().getInputStream()));
            st.setAttribute("datasourceId", (Object)this.datasourceId);
            st.setAttribute("xpath", (Object)api.getMetadataIdentifierPath().replace("\"", "'"));
            st.setAttribute("baseurl", (Object)URLEncoder.encode(api.getBaseurl(), "UTF-8"));
            st.setAttribute("metadatanamespace", (Object)this.getMetadataNamespace(api.getApiParams().stream().filter(a -> a.getParam().equalsIgnoreCase("format")).map(a -> a.getValue()).findFirst().orElse(null)));
            if (token.getEnv().hasAttribute("namespacePrefix")) {
                st.setAttribute("namespacePrefix", (Object)token.getEnv().getAttribute("namespacePrefix"));
            } else if (StringUtils.isNotBlank((CharSequence)ds.getNamespaceprefix())) {
                st.setAttribute("namespacePrefix", (Object)ds.getNamespaceprefix());
            } else {
                st.setAttribute("namespacePrefix", (Object)this.datasourceId);
            }
            W3CEndpointReference epr = this.xsltMappedResultSetFactory.createMappedResultSet(new EPRUtils().getEpr(inputEpr), st.toString());
            token.getEnv().setAttribute(this.outputEprParam, epr.toString());
            return Arc.DEFAULT_ARC;
        }
        catch (ISLookUpException e) {
            throw new MSROException("Error while initializing mdBuilder template (" + this.getMdBuilderTemplateXslt().getFilename() + ") for datasource " + this.datasourceId, (Throwable)e);
        }
        catch (IOException e) {
            throw new MSROException("Error parsing template: " + this.getMdBuilderTemplateXslt().getFilename(), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)st.toString());
            throw new MSROException((Throwable)e);
        }
    }

    private String getMetadataNamespace(String mdFormat) {
        if (StringUtils.isBlank((CharSequence)mdFormat)) {
            return "";
        }
        try {
            String xQuery = "/*[.//RESOURCE_TYPE/@value='MetadataFormatDSResourceType']//METADATAFORMAT[@Prefix='{format}']/@NameSpace/string()";
            xQuery = xQuery.replace("{format}", mdFormat);
            return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xQuery);
        }
        catch (ISLookUpException e) {
            log.error((Object)"The interface is not OAI or the format is not found in the MetadataFormatDSResourceType, thus metadata format in the <about> section cannot managed here and it will be leaved empty (for the time being)");
            return "";
        }
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public XSLTMappedResultSetFactory getXsltMappedResultSetFactory() {
        return this.xsltMappedResultSetFactory;
    }

    @Required
    public void setXsltMappedResultSetFactory(XSLTMappedResultSetFactory xsltMappedResultSetFactory) {
        this.xsltMappedResultSetFactory = xsltMappedResultSetFactory;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public Resource getMdBuilderTemplateXslt() {
        return this.mdBuilderTemplateXslt;
    }

    @Required
    public void setMdBuilderTemplateXslt(Resource mdBuilderTemplateXslt) {
        this.mdBuilderTemplateXslt = mdBuilderTemplateXslt;
    }
}

