/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.msro.rmi.MSROException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class ValidNodeValuesFetcher
implements UnaryFunction<List<DnetParamValue>, Map<String, String>> {
    private String name;
    private static final Log log = LogFactory.getLog(ValidNodeValuesFetcher.class);

    public final List<DnetParamValue> evaluate(Map<String, String> params) {
        try {
            return this.obtainValues(params);
        }
        catch (Throwable e) {
            log.error((Object)"Error obtaing values", e);
            return Lists.newArrayList();
        }
    }

    protected abstract List<DnetParamValue> obtainValues(Map<String, String> var1) throws Exception;

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    protected void verifyParams(Map<String, String> params, String ... pnames) throws MSROException {
        for (String s : pnames) {
            if (params.containsKey(s)) continue;
            throw new MSROException("Parameter not found: " + s);
        }
    }

    public class DnetParamValue
    implements Comparable<DnetParamValue> {
        private String id;
        private String name;

        public DnetParamValue(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(DnetParamValue o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

