/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.download;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import com.googlecode.sarasvati.env.Env;
import eu.dnetlib.data.download.rmi.DownloadService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.ProgressJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.resultset.ProcessCountingResultSetFactory;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadFromMetadataJobNode
extends BlackboardJobNode
implements ProgressJobNode {
    private static final Log log = LogFactory.getLog(DownloadFromMetadataJobNode.class);
    protected String regularExpression;
    private String inputeprParam;
    private String objectStoreID;
    private String plugin;
    private String protocol;
    private String mimeType;
    private int numberOfThreads = -1;
    private int connectTimeoutMs = -1;
    private int readTimeoutMs = -1;
    private int sleepTimeMs = 0;
    @Autowired
    private ProcessCountingResultSetFactory processCountingResultSetFactory;
    private ResultsetProgressProvider progressProvider;

    @Override
    protected String obtainServiceId(NodeToken token) {
        return this.getServiceLocator().getServiceId(DownloadService.class);
    }

    @Override
    protected void prepareJob(BlackboardJob job, NodeToken token) throws Exception {
        job.setAction("DOWNLOAD");
        String eprS = token.getEnv().getAttribute(this.getInputeprParam());
        this.progressProvider = this.processCountingResultSetFactory.createProgressProvider(token.getProcess(), eprS);
        job.getParameters().put("epr", this.progressProvider.getEpr().toString());
        job.getParameters().put("protocol", this.getProtocol());
        job.getParameters().put("plugin", this.getPlugin());
        job.getParameters().put("mimeType", this.getMimeType());
        job.getParameters().put("objectStoreID", this.getObjectStoreID());
        if (this.getNumberOfThreads() > 0) {
            job.getParameters().put("numberOfThreads", "" + this.getNumberOfThreads());
        }
        if (this.getConnectTimeoutMs() > 0) {
            job.getParameters().put("connectTimeoutMs", "" + this.getConnectTimeoutMs());
        }
        if (this.getReadTimeoutMs() > 0) {
            job.getParameters().put("readTimeoutMs", "" + this.getReadTimeoutMs());
        }
        if (this.getSleepTimeMs() > 0) {
            job.getParameters().put("sleepTimeMs", "" + this.getSleepTimeMs());
        }
        if (!StringUtils.isEmpty((String)this.getRegularExpression())) {
            job.getParameters().put("regularExpressions", this.getRegularExpression());
        }
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Engine engine, NodeToken token) {
        return new BlackboardWorkflowJobListener(engine, token){

            @Override
            protected void populateEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", responseParams.get("total"));
                String base64 = responseParams.get("report");
                if (StringUtils.isNotBlank((String)base64) && Base64.isBase64((byte[])base64.getBytes())) {
                    String report = new String(Base64.decodeBase64((byte[])base64.getBytes()));
                    log.info((Object)"found download report");
                    log.debug((Object)report);
                    env.setAttribute("mainlog:report", report);
                } else {
                    log.warn((Object)"unable to find or decode download report");
                }
            }
        };
    }

    public String getInputeprParam() {
        return this.inputeprParam;
    }

    public void setInputeprParam(String inputeprParam) {
        this.inputeprParam = inputeprParam;
    }

    public String getObjectStoreID() {
        return this.objectStoreID;
    }

    public void setObjectStoreID(String objectStoreID) {
        this.objectStoreID = objectStoreID;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public void setPlugin(String plugin) {
        this.plugin = plugin;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protol) {
        this.protocol = protol;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    public int getSleepTimeMs() {
        return this.sleepTimeMs;
    }

    public void setSleepTimeMs(int sleepTimeMs) {
        this.sleepTimeMs = sleepTimeMs;
    }
}

