/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.download.UrlExtractor;
import javax.annotation.Resource;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class RetrieveURLSJobNode
extends SimpleJobNode {
    private String inputEprParam;
    private String outputEprParam;
    private String xpath;
    private String xpathMetadataId;
    private String xpathOpenAccess;
    private String xpathEmbargoDate;
    @Autowired
    private ResultSetClientFactory resultSetClientFactory;
    @Resource(name="iterableResultSetFactory")
    private IterableResultSetFactory resultSetFactory;

    @Override
    protected String execute(NodeToken token) throws Exception {
        W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(this.inputEprParam));
        IterableResultSetClient input = this.resultSetClientFactory.getClient(inputEpr);
        Iterable extractedUrls = Iterables.transform((Iterable)input, (Function)new UrlExtractor(this.xpath, this.xpathMetadataId, this.xpathOpenAccess, this.xpathEmbargoDate));
        W3CEndpointReference eprUrls = this.resultSetFactory.createIterableResultSet(extractedUrls);
        token.getEnv().setAttribute(this.getOutputEprParam(), eprUrls.toString());
        return Arc.DEFAULT_ARC;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getXpathMetadataId() {
        return this.xpathMetadataId;
    }

    @Required
    public void setXpathMetadataId(String xpathMetadataId) {
        this.xpathMetadataId = xpathMetadataId;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public IterableResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(IterableResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getXpathOpenAccess() {
        return this.xpathOpenAccess;
    }

    public void setXpathOpenAccess(String xpathOpenAccess) {
        this.xpathOpenAccess = xpathOpenAccess;
    }

    public String getXpathEmbargoDate() {
        return this.xpathEmbargoDate;
    }

    public void setXpathEmbargoDate(String xpathEmbargoDate) {
        this.xpathEmbargoDate = xpathEmbargoDate;
    }
}

