/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.LocalDatasourceManager;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.springframework.beans.factory.annotation.Autowired;

public class VerifyDatasourceJobNode
extends SimpleJobNode {
    @Autowired
    private LocalDatasourceManager<Datasource<?, ?, ?>, Api<?>> dsManager;
    private String expectedDatasourceTypes;
    private String expectedCompatibilityLevels;
    private Boolean expectedConsentTermsOfUse;
    private Boolean expectedFullTextDownload;

    @Override
    protected String execute(NodeToken token) throws Exception {
        String dsId = token.getFullEnv().getAttribute("dataprovider:id");
        String ifaceId = token.getFullEnv().getAttribute("dataprovider:interface");
        String type = this.dsManager.getDs(dsId).getEoscDatasourceType();
        this.verifyValue(type, this.expectedDatasourceTypes);
        Api api = this.dsManager.getApis(dsId).stream().filter(a -> a.getId().equals(ifaceId)).findFirst().orElseThrow(() -> new MSROException("Intervace not found: " + ifaceId));
        this.verifyValue(api.getCompatibility(), this.expectedCompatibilityLevels);
        if (this.expectedConsentTermsOfUse != null || this.expectedFullTextDownload != null) {
            Datasource ds = this.dsManager.getDs(dsId);
            this.verifyValue(ds.getConsentTermsOfUse(), this.expectedConsentTermsOfUse);
            this.verifyValue(ds.getFullTextDownload(), this.expectedFullTextDownload);
        }
        token.getFullEnv().setAttribute("dataprovider:interface:compliance", api.getCompatibility());
        return Arc.DEFAULT_ARC;
    }

    private void verifyValue(Boolean value, Boolean expected) throws MSROException {
        if (expected != null && value != expected) {
            throw new MSROException("Invalid boolean value: " + value + ", expected value was " + expected);
        }
    }

    private void verifyValue(String value, String expected) throws Exception {
        if (value != null && expected != null && !expected.isEmpty()) {
            for (String s : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)expected)) {
                if (!value.equalsIgnoreCase(s)) continue;
                return;
            }
            throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
        }
    }

    public String getExpectedDatasourceTypes() {
        return this.expectedDatasourceTypes;
    }

    public void setExpectedDatasourceTypes(String expectedDatasourceTypes) {
        this.expectedDatasourceTypes = expectedDatasourceTypes;
    }

    public Boolean getExpectedConsentTermsOfUse() {
        return this.expectedConsentTermsOfUse;
    }

    public void setExpectedConsentTermsOfUse(Boolean expectedConsentTermsOfUse) {
        this.expectedConsentTermsOfUse = expectedConsentTermsOfUse;
    }

    public Boolean getExpectedFullTextDownload() {
        return this.expectedFullTextDownload;
    }

    public void setExpectedFullTextDownload(Boolean expectedFullTextDownload) {
        this.expectedFullTextDownload = expectedFullTextDownload;
    }

    public String getExpectedCompatibilityLevels() {
        return this.expectedCompatibilityLevels;
    }

    public void setExpectedCompatibilityLevels(String expectedCompatibilityLevels) {
        this.expectedCompatibilityLevels = expectedCompatibilityLevels;
    }
}

