package eu.dnetlib.msro.oai.workflows.nodes;

import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import org.apache.commons.lang.StringUtils;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.oai.store.OAIStoreService;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public abstract class AbstractOAIJobNode extends BlackboardJobNode {

	private String oaiDbNameParam = OAIParameterNames.OAI_DB;
	// overrides the value in the env param oaiDbNameParam
	private String oaiDbName;

	private String oaiFormatParam = OAIParameterNames.OAI_FORMAT_NAME;
	private String oaiFormat;

	private String oaiLayoutParam = OAIParameterNames.OAI_FORMAT_LAYOUT;
	private String oaiLayout;

	private String oaiInterpretationParam = OAIParameterNames.OAI_FORMAT_INTERPRETATION;
	private String oaiInterpretation;

	private String oaiSourceParam = OAIParameterNames.OAI_SOURCE;
	// overrides the value in the env param oaiSourceParam
	private String oaiSource;

	protected String getTheOAIDBName(final NodeToken token) {
		return StringUtils.isNotBlank(oaiDbName)? oaiDbName : token.getEnv().getAttribute(oaiDbNameParam);
	}
	protected String getTheOAIFormat(final NodeToken token) {
		return StringUtils.isNotBlank(oaiFormat)? oaiFormat : token.getEnv().getAttribute(oaiFormatParam);
	}
	protected String getTheOAILayout(final NodeToken token) {
		return StringUtils.isNotBlank(oaiLayout)? oaiLayout : token.getEnv().getAttribute(oaiLayoutParam);
	}
	protected String getTheOAIInterpretation(final NodeToken token) {
		return StringUtils.isNotBlank(oaiInterpretation)? oaiInterpretation : token.getEnv().getAttribute(oaiInterpretationParam);
	}
	protected String getTheOAISource(final NodeToken token) {
		return StringUtils.isNotBlank(oaiSource)? oaiSource : token.getEnv().getAttribute(oaiSourceParam);
	}

	protected String getTheOAICollection(final NodeToken token) {
		return getTheOAIFormat(token) + "-" + getTheOAILayout(token) + "-" + getTheOAIInterpretation(token);
	}


	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(OAIStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException {
		job.getParameters().put(OAIParameterNames.OAI_DB, getTheOAIDBName(token));
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_NAME, getTheOAIFormat(token));
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_LAYOUT, getTheOAILayout(token));
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_INTERPRETATION, getTheOAIInterpretation(token));
		job.getParameters().put(OAIParameterNames.OAI_COLLECTON, getTheOAICollection(token));
		String theSource = getTheOAISource(token);
		if(StringUtils.isNotBlank(theSource)) job.getParameters().put(OAIParameterNames.OAI_SOURCE, getTheOAISource(token));
		completePrepareJob(job, token);
	}

	abstract void completePrepareJob(final BlackboardJob job, final NodeToken token) throws ResultSetException;

	public String getOaiDbNameParam() {
		return oaiDbNameParam;
	}

	public void setOaiDbNameParam(final String oaiDbNameParam) {
		this.oaiDbNameParam = oaiDbNameParam;
	}

	public String getOaiDbName() {
		return oaiDbName;
	}

	public void setOaiDbName(final String oaiDbName) {
		this.oaiDbName = oaiDbName;
	}

	public String getOaiFormatParam() {
		return oaiFormatParam;
	}

	public void setOaiFormatParam(final String oaiFormatParam) {
		this.oaiFormatParam = oaiFormatParam;
	}

	public String getOaiFormat() {
		return oaiFormat;
	}

	public void setOaiFormat(final String oaiFormat) {
		this.oaiFormat = oaiFormat;
	}

	public String getOaiLayoutParam() {
		return oaiLayoutParam;
	}

	public void setOaiLayoutParam(final String oaiLayoutParam) {
		this.oaiLayoutParam = oaiLayoutParam;
	}

	public String getOaiLayout() {
		return oaiLayout;
	}

	public void setOaiLayout(final String oaiLayout) {
		this.oaiLayout = oaiLayout;
	}

	public String getOaiInterpretationParam() {
		return oaiInterpretationParam;
	}

	public void setOaiInterpretationParam(final String oaiInterpretationParam) {
		this.oaiInterpretationParam = oaiInterpretationParam;
	}

	public String getOaiInterpretation() {
		return oaiInterpretation;
	}

	public void setOaiInterpretation(final String oaiInterpretation) {
		this.oaiInterpretation = oaiInterpretation;
	}

	public String getOaiSourceParam() {
		return oaiSourceParam;
	}

	public void setOaiSourceParam(final String oaiSourceParam) {
		this.oaiSourceParam = oaiSourceParam;
	}

	public String getOaiSource() {
		return oaiSource;
	}

	public void setOaiSource(final String oaiSource) {
		this.oaiSource = oaiSource;
	}
}
