package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

/**
 * Create indexes on the oaistore on the fields specified in the parameter.
 */
public class OAICreateIndexJobNode extends AbstractOAIJobNode {

	/**
	 * Name of the fields (comma separated) to be included in the same index. For several indexes separate the fieldNames with ;
	 * <p>
	 * Examples: field1,field2 -- one compound index on the given two fields field1,field2;field3,field4 -- two compound indices: one on
	 * field1 and field2, the other on field3 and field4
	 * </p>
	 * **/
	private String fieldNames;

	@Override
	public void completePrepareJob(final BlackboardJob job, final NodeToken token) {
		job.setAction("CREATE_OAI_INDEX");
		job.getParameters().put(OAIParameterNames.OAI_INDEXES, getFieldNames());
	}

	public String getFieldNames() {
		return fieldNames;
	}

	public void setFieldNames(final String fieldNames) {
		this.fieldNames = fieldNames;
	}
}
