package eu.dnetlib.msro.oai.workflows.nodes;

import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.utils.OAIParameterNames;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;

public class OAISetsCountJobNode extends AbstractOAIJobNode {

	private String configuredOnly;

	@Override
	void completePrepareJob(final BlackboardJob job, final NodeToken token) {
		job.setAction("COUNT_SETS");
		job.getParameters().put(OAIParameterNames.OAI_CONFIGURED_SETS_ONLY, getConfiguredOnly());
	}

	public String getConfiguredOnly() {
		return configuredOnly;
	}

	public void setConfiguredOnly(final String configuredOnly) {
		this.configuredOnly = configuredOnly;
	}

}
